/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MPDataSyncPacket
implements IMessage,
IMessageHandler<MPDataSyncPacket, IMessage> {
    protected String name;
    protected String lastname;
    protected int age;
    protected int raceID;
    protected int jobID;

    public MPDataSyncPacket() {
    }

    public MPDataSyncPacket(String name, String lastname, int age, int raceID, int jobID) {
        this.name = name;
        this.lastname = lastname;
        this.age = age;
        this.raceID = raceID;
        this.jobID = jobID;
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.lastname = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.age = buf.readInt();
        this.raceID = buf.readInt();
        this.jobID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.lastname);
        buf.writeInt(this.age);
        buf.writeInt(this.raceID);
        buf.writeInt(this.jobID);
    }

    public IMessage onMessage(MPDataSyncPacket message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            IMinePieceData data = (IMinePieceData)ctx.getServerHandler().field_147369_b.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            assert (data != null);
            data.setRPName(message.name);
            data.setRPLastName(message.lastname);
            data.setRPAge(message.age);
            data.setJob(message.jobID);
            data.setRace(message.raceID);
            data.clientSync(ctx.getServerHandler().field_147369_b);
            ctx.getServerHandler().field_147369_b.refreshDisplayName();
        }
        return null;
    }
}

