/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GiveItemPacket
implements IMessage,
IMessageHandler<GiveItemPacket, IMessage> {
    private UUID playerUUID;
    private String itemRegistryName;
    private int count;
    private int meta;

    public GiveItemPacket() {
    }

    public GiveItemPacket(UUID playerUUID, String itemRegistryName, int count, int meta) {
        this.playerUUID = playerUUID;
        this.itemRegistryName = itemRegistryName;
        this.count = count;
        this.meta = meta;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = new UUID(buf.readLong(), buf.readLong());
        this.itemRegistryName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.count = buf.readInt();
        this.meta = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.playerUUID.getMostSignificantBits());
        buf.writeLong(this.playerUUID.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.itemRegistryName);
        buf.writeInt(this.count);
        buf.writeInt(this.meta);
    }

    public IMessage onMessage(GiveItemPacket message, MessageContext ctx) {
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(() -> {
            Item item;
            EntityPlayerMP player = (EntityPlayerMP)ctx.getServerHandler().field_147369_b.func_71121_q().func_152378_a(message.playerUUID);
            if (player != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(message.itemRegistryName))) != null) {
                ItemStack stack = new ItemStack(item, message.count, message.meta);
                boolean success = player.field_71071_by.func_70441_a(stack);
                if (!success) {
                    player.func_71019_a(stack, false);
                }
                player.field_71069_bz.func_75142_b();
            }
        });
        return null;
    }
}

