/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class FullModificationsPacket
implements IMessage,
IMessageHandler<FullModificationsPacket, FullModificationsPacket> {
    private ArrayList<String> modifications;
    private ArrayList<String> skinModifications;
    private String pose;
    private String skin;
    private int skinColor;
    private int modificationColor;
    private UUID targetUUID;
    private UUID player;

    public FullModificationsPacket() {
    }

    public FullModificationsPacket(ArrayList<String> modifications, ArrayList<String> skinModifications, String pose, String skin, int skinColor, int modificationColor, UUID targetUUID) {
        this.modifications = modifications;
        this.skinModifications = skinModifications;
        this.pose = pose;
        this.targetUUID = targetUUID;
        this.skin = skin;
        this.skinColor = skinColor;
        this.modificationColor = modificationColor;
    }

    public FullModificationsPacket(IPlayerModifications data, UUID targetUUID, UUID player) {
        this.modifications = data.getModifications();
        this.skinModifications = data.getSkinModifications();
        this.pose = data.getPose();
        this.skin = data.getSkin();
        this.skinColor = data.getSkinColor();
        this.modificationColor = data.getModificationColor();
        this.targetUUID = targetUUID;
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        this.skinColor = buf.readInt();
        this.modificationColor = buf.readInt();
        this.targetUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int size = buf.readInt();
        this.modifications = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.modifications.add(name);
        }
        int sizeSkin = buf.readInt();
        this.skinModifications = new ArrayList(sizeSkin);
        for (int i = 0; i < sizeSkin; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.skinModifications.add(name);
        }
        this.pose = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.skin = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.skinColor);
        buf.writeInt(this.modificationColor);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.targetUUID.toString());
        buf.writeInt(this.modifications.size());
        for (String modificationName : this.modifications) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)modificationName);
        }
        buf.writeInt(this.skinModifications.size());
        for (String modificationName : this.skinModifications) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)modificationName);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.pose);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skin);
        if (this.player != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public FullModificationsPacket onMessage(FullModificationsPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return;
                }
                world.field_73010_i.stream().filter(p -> p.func_110124_au().equals(message.targetUUID)).findFirst().ifPresent(player -> {
                    IPlayerModifications data = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
                    if (data != null) {
                        data.setModifications(new ArrayList<String>(message.modifications));
                        data.setSkinModifications(new ArrayList<String>(message.skinModifications));
                        data.setPose(message.pose);
                        data.setSkin(message.skin);
                        data.setSkinColor(message.skinColor);
                        data.setModificationColor(message.modificationColor);
                    }
                });
            });
        }
        return null;
    }
}

