/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class FullMPStatsPacket
implements IMessage,
IMessageHandler<FullMPStatsPacket, IMessage> {
    public int strength;
    public int hp;
    public int toughness;
    public int speed;
    public int energy;
    public int maxEnergy;
    public int statPoints;

    public FullMPStatsPacket() {
    }

    public FullMPStatsPacket(IMinePieceStats stats) {
        this.strength = stats.getStrength();
        this.hp = stats.getHP();
        this.toughness = stats.getToughness();
        this.speed = stats.getSpeed();
        this.energy = stats.getEnergy();
        this.maxEnergy = stats.getMaxEnergy();
        this.statPoints = stats.getStatPoints();
    }

    public FullMPStatsPacket(int strength, int hp, int toughness, int speed, int energy, int maxEnergy, int statPoints) {
        this.strength = strength;
        this.hp = hp;
        this.toughness = toughness;
        this.speed = speed;
        this.energy = energy;
        this.maxEnergy = maxEnergy;
        this.statPoints = statPoints;
    }

    public void fromBytes(ByteBuf buf) {
        this.strength = buf.readInt();
        this.hp = buf.readInt();
        this.toughness = buf.readInt();
        this.speed = buf.readInt();
        this.energy = buf.readInt();
        this.maxEnergy = buf.readInt();
        this.statPoints = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.strength);
        buf.writeInt(this.hp);
        buf.writeInt(this.toughness);
        buf.writeInt(this.speed);
        buf.writeInt(this.energy);
        buf.writeInt(this.maxEnergy);
        buf.writeInt(this.statPoints);
    }

    public IMessage onMessage(FullMPStatsPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                IMinePieceStats cap = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
                cap.setStrength(message.strength);
                cap.setHP(message.hp);
                cap.setToughness(message.toughness);
                cap.setSpeed(message.speed);
                cap.setEnergy(message.energy);
                cap.setMaxEnergy(message.maxEnergy);
                cap.setStatPoints(message.statPoints);
            });
        }
        return null;
    }
}

