/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class FullMPDataPacket
implements IMessage,
IMessageHandler<FullMPDataPacket, IMessage> {
    protected String name;
    protected String lastname;
    protected int level;
    protected int age;
    protected int raceID;
    protected int jobID;
    protected int xp;
    protected int jobXP;
    protected int jobLevel;
    protected ArrayList<String> skills;
    protected UUID targetUUID;

    public FullMPDataPacket() {
    }

    public FullMPDataPacket(IMinePieceData data, UUID targetUUID) {
        this.name = data.getRPName();
        this.lastname = data.getRPLastName();
        this.level = data.getLevel();
        this.age = data.getRPAge();
        this.raceID = data.getRaceID();
        this.xp = data.getXP();
        this.jobID = data.getJobID();
        this.jobXP = data.getJobXP();
        this.jobLevel = data.getJobLevel();
        this.skills = data.getSkills();
    }

    public FullMPDataPacket(String name, String lastname, int level, int age, int raceID, int xp, int jobID, int jobLevel, int jobXP, ArrayList<String> skills, UUID targetUUID) {
        this.name = name;
        this.lastname = lastname;
        this.level = level;
        this.age = age;
        this.raceID = raceID;
        this.xp = xp;
        this.jobID = jobID;
        this.jobLevel = jobLevel;
        this.jobXP = jobXP;
        this.targetUUID = targetUUID;
        this.skills = skills;
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.lastname = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.level = buf.readInt();
        this.age = buf.readInt();
        this.raceID = buf.readInt();
        this.xp = buf.readInt();
        this.jobID = buf.readInt();
        this.jobLevel = buf.readInt();
        this.jobXP = buf.readInt();
        this.targetUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int skillsSize = buf.readInt();
        this.skills = new ArrayList();
        for (int i = 0; i < skillsSize; ++i) {
            this.skills.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.lastname);
        buf.writeInt(this.level);
        buf.writeInt(this.age);
        buf.writeInt(this.raceID);
        buf.writeInt(this.xp);
        buf.writeInt(this.jobID);
        buf.writeInt(this.jobLevel);
        buf.writeInt(this.jobXP);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.targetUUID.toString());
        buf.writeInt(this.skills.size());
        for (String skill : this.skills) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)skill);
        }
    }

    public IMessage onMessage(FullMPDataPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                for (EntityPlayer player : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
                    if (!player.func_110124_au().equals(message.targetUUID)) continue;
                    IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                    if (data == null) break;
                    data.setRPName(message.name);
                    data.setRPLastName(message.lastname);
                    data.setRPAge(message.age);
                    data.setLevel(message.level);
                    data.setRace(message.raceID);
                    data.setXP(message.xp);
                    data.setJob(message.jobID);
                    data.setJobLevel(message.jobLevel);
                    data.setJobXP(message.jobXP);
                    data.setSkills(message.skills);
                    break;
                }
            });
        }
        return null;
    }
}

