/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class FullCooldownsPacket
implements IMessage,
IMessageHandler<FullCooldownsPacket, IMessage> {
    protected HashMap<String, Long> cooldowns;

    public FullCooldownsPacket() {
    }

    public FullCooldownsPacket(HashMap<String, Long> cooldowns) {
        this.cooldowns = cooldowns;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.cooldowns = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String key = ByteBufUtils.readUTF8String((ByteBuf)buf);
            long value = buf.readLong();
            this.cooldowns.put(key, value);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.cooldowns.size());
        for (Map.Entry<String, Long> entry : this.cooldowns.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeLong(entry.getValue().longValue());
        }
    }

    public IMessage onMessage(FullCooldownsPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                IMinePieceCooldown cap = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
                cap.setCooldowns(message.cooldowns);
            });
        }
        return null;
    }
}

