/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.client.render.LeashRenderer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CordageSyncPacket
implements IMessage,
IMessageHandler<CordageSyncPacket, IMessage> {
    private UUID leashedPlayerUUID;
    private UUID holderPlayerUUID;
    private boolean isLeashed;

    public CordageSyncPacket() {
    }

    public CordageSyncPacket(UUID leashedPlayerUUID, UUID holderPlayerUUID, boolean isLeashed) {
        this.leashedPlayerUUID = leashedPlayerUUID;
        this.holderPlayerUUID = holderPlayerUUID;
        this.isLeashed = isLeashed;
    }

    public IMessage onMessage(CordageSyncPacket message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(() -> {
            if (message.isLeashed) {
                LeashRenderer.updateLeash(message.leashedPlayerUUID, message.holderPlayerUUID);
            } else {
                LeashRenderer.removeLeash(message.leashedPlayerUUID);
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.leashedPlayerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.isLeashed = buf.readBoolean();
        this.holderPlayerUUID = this.isLeashed ? UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)) : null;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.leashedPlayerUUID.toString());
        buf.writeBoolean(this.isLeashed);
        if (this.isLeashed) {
            if (this.holderPlayerUUID == null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.leashedPlayerUUID.toString());
                System.err.println("WARN: Sending PacketSyncLeash(isLeashed=true) with null holderUUID!");
            } else {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.holderPlayerUUID.toString());
            }
        }
    }
}

