/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.client.events.InputEvent;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CancelMovementPacket
implements IMessage,
IMessageHandler<CancelMovementPacket, IMessage> {
    private UUID playerUUID;
    private boolean shouldCancelMovement;

    public CancelMovementPacket() {
    }

    public CancelMovementPacket(UUID playerUUID, boolean shouldCancelMovement) {
        this.playerUUID = playerUUID;
        this.shouldCancelMovement = shouldCancelMovement;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.shouldCancelMovement = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        buf.writeBoolean(this.shouldCancelMovement);
    }

    public IMessage onMessage(CancelMovementPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            if (message.shouldCancelMovement) {
                InputEvent.shouldCancelMovement.add(message.playerUUID);
            } else {
                InputEvent.shouldCancelMovement.remove(message.playerUUID);
            }
        }
        return null;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public boolean isShouldCancelMovement() {
        return this.shouldCancelMovement;
    }
}

