/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.weapons.shooting;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.minepiece.MinePiece;
import fr.minepiece.common.init.ModItems;
import fr.minepiece.common.items.INBTProvider;
import fr.minepiece.common.items.weapons.shooting.BaseItemShooting;
import fr.minepiece.common.items.weapons.shooting.TieredBazooka;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TieredShootingWeapon
extends BaseItemShooting
implements INBTProvider {
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    protected static final float PISTOL_MELEE_DAMAGE = 2.0f;
    protected static final float RIFLE_MELEE_DAMAGE = 3.0f;
    protected static final float BAZOOKA_MELEE_DAMAGE = 4.0f;
    protected final int maxTier;
    protected final int[] durabilities;
    protected final float[] damages;
    protected final Item fragmentItem;
    protected final String weaponType;

    public TieredShootingWeapon(String name, int maxTier, int[] durabilities, float[] damages, Item fragmentItem, Item ammoItem, float baseAccuracy, boolean hasParabolicPath, float velocityFactor, float gravity) {
        super(name, ammoItem, durabilities[0], damages[0], baseAccuracy, hasParabolicPath, velocityFactor, gravity);
        this.maxTier = maxTier;
        this.durabilities = durabilities;
        this.damages = damages;
        this.fragmentItem = fragmentItem;
        this.weaponType = name.contains("pistol") ? "pistol" : (name.contains("rifle") ? "rifle" : (name.contains("bazooka") ? "bazooka" : "pistol"));
        this.func_77637_a(MinePiece.WEAPONS);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    protected abstract ActionResult<ItemStack> fireWeaponWithTier(World var1, EntityPlayer var2, EnumHand var3, ItemStack var4, int var5);

    @Override
    protected ActionResult<ItemStack> fireWeapon(World world, EntityPlayer player, EnumHand hand, ItemStack stack) {
        int tier = this.getTier(stack);
        return this.fireWeaponWithTier(world, player, hand, stack, tier);
    }

    public int getMaxDamage(ItemStack stack) {
        int tier = this.getTier(stack);
        return this.durabilities[tier];
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77951_h();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)this.getMaxDamage(stack);
    }

    public boolean func_77614_k() {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int tier = 0; tier < this.maxTier; ++tier) {
                ItemStack stack = this.createTieredWeapon(tier);
                items.add((Object)stack);
            }
        }
    }

    public ItemStack createTieredWeapon(int tier) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Tier", tier);
        stack.func_77982_d(nbt);
        return stack;
    }

    public int getTier(ItemStack stack) {
        if (stack.func_77942_o()) {
            return this.getTier(stack.func_77978_p());
        }
        return 0;
    }

    public int getTier(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Tier")) {
            return nbt.func_74762_e("Tier");
        }
        return 0;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && this.cooldownPassed(stack)) {
            ItemStack itemStack;
            int i;
            boolean hasAmmo = false;
            boolean hasPowder = false;
            int tier = this.getTier(stack);
            int powderConsumption = 1;
            if (this instanceof TieredBazooka) {
                powderConsumption = 5;
            }
            if (playerIn.func_184812_l_()) {
                hasAmmo = true;
                hasPowder = true;
            } else {
                for (i = 0; i < playerIn.field_71071_by.func_70302_i_(); ++i) {
                    itemStack = playerIn.field_71071_by.func_70301_a(i);
                    if (itemStack.func_77973_b() != this.ammoItem) continue;
                    hasAmmo = true;
                    break;
                }
                for (i = 0; i < playerIn.field_71071_by.func_70302_i_(); ++i) {
                    int maxDamage;
                    int currentDamage;
                    itemStack = playerIn.field_71071_by.func_70301_a(i);
                    if (itemStack.func_77973_b() != ModItems.SAC_POUDRE || (currentDamage = itemStack.func_77952_i()) + powderConsumption > (maxDamage = itemStack.func_77958_k())) continue;
                    hasPowder = true;
                    break;
                }
            }
            if (hasAmmo && hasPowder) {
                if (!playerIn.func_184812_l_()) {
                    for (i = 0; i < playerIn.field_71071_by.func_70302_i_(); ++i) {
                        itemStack = playerIn.field_71071_by.func_70301_a(i);
                        if (itemStack.func_77973_b() != ModItems.SAC_POUDRE) continue;
                        itemStack.func_77972_a(powderConsumption, (EntityLivingBase)playerIn);
                        break;
                    }
                    for (i = 0; i < playerIn.field_71071_by.func_70302_i_(); ++i) {
                        itemStack = playerIn.field_71071_by.func_70301_a(i);
                        if (itemStack.func_77973_b() != this.ammoItem) continue;
                        itemStack.func_190918_g(1);
                        break;
                    }
                }
                this.resetCooldown(stack);
                this.applyVisualCooldown(playerIn, stack);
                return this.fireWeaponWithTier(worldIn, playerIn, handIn, stack, tier);
            }
            if (!hasAmmo) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.no_ammo", new Object[]{new TextComponentTranslation(this.ammoItem.func_77658_a() + ".name", new Object[0]).func_150254_d()}));
            }
            if (!hasPowder) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.no_powder", new Object[]{new TextComponentTranslation(ModItems.SAC_POUDRE.func_77658_a() + ".name", new Object[0]).func_150254_d()}));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void handleWeaponBreak(ItemStack stack, EntityPlayer player) {
        ItemStack fragmentStack;
        int tier = this.getTier(stack);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.weapon_break", new Object[]{new TextComponentTranslation(this.func_77658_a() + ".name", new Object[0]).func_150254_d()}));
        if (this.fragmentItem != null && !player.field_71071_by.func_70441_a(fragmentStack = new ItemStack(this.fragmentItem, 1, tier))) {
            player.func_71019_a(fragmentStack, false);
        }
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(2, attacker);
        return true;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() >= this.getMaxDamage(stack) && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            ItemStack brokenStack = stack.func_77946_l();
            player.field_71071_by.func_70299_a(itemSlot, ItemStack.field_190927_a);
            this.handleWeaponBreak(brokenStack, player);
        }
    }

    protected float getMeleeDamage() {
        switch (this.weaponType) {
            case "pistol": {
                return 2.0f;
            }
            case "rifle": {
                return 3.0f;
            }
            case "bazooka": {
                return 4.0f;
            }
        }
        return 2.0f;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            float meleeDamage = this.getMeleeDamage();
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", (double)meleeDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", -3.0, 0));
        }
        return multimap;
    }

    public String func_77667_c(ItemStack stack) {
        int tier = this.getTier(stack);
        return super.func_77658_a() + ".tier" + (tier + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        TextFormatting color;
        int tier = this.getTier(stack);
        switch (tier) {
            case 1: {
                color = TextFormatting.AQUA;
                break;
            }
            case 2: {
                color = TextFormatting.GREEN;
                break;
            }
            default: {
                color = TextFormatting.WHITE;
            }
        }
        tooltip.add(color + "Tier " + (tier + 1));
        int maxDamage = this.getMaxDamage(stack);
        int currentDamage = stack.func_77952_i();
        int durabilityLeft = maxDamage - currentDamage;
        tooltip.add(TextFormatting.GRAY + "Durabilit\u00e9: " + durabilityLeft + " / " + maxDamage);
        tooltip.add(TextFormatting.YELLOW + "Munitions: " + this.ammoItem.func_77653_i(new ItemStack(this.ammoItem)));
        tooltip.add(TextFormatting.YELLOW + "N\u00e9cessite: " + ModItems.SAC_POUDRE.func_77653_i(new ItemStack(ModItems.SAC_POUDRE)));
        tooltip.add(TextFormatting.RED + "D\u00e9g\u00e2ts de tir: " + this.damages[tier]);
        tooltip.add(TextFormatting.RED + "D\u00e9g\u00e2ts de m\u00eal\u00e9e: " + this.getMeleeDamage());
    }

    @Override
    public String getVariantName(NBTTagCompound nbt) {
        return "tier_" + (this.getTier(nbt) + 1);
    }

    public float getDamageForTier(int tier) {
        return this.damages[tier];
    }

    public float getAdjustedAccuracy(int tier) {
        return this.baseAccuracy * (1.0f - (float)tier * 0.2f);
    }

    public float getAdjustedVelocityFactor(int tier) {
        return this.velocityFactor * (1.0f + (float)tier * 0.15f);
    }
}

