/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.weapons.shooting;

import fr.minepiece.common.entity.projectile.EntityBullet;
import fr.minepiece.common.init.ModWeapons;
import fr.minepiece.common.items.weapons.shooting.TieredShootingWeapon;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.PlayCustomSoundPacket;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TieredFlintlockPistol
extends TieredShootingWeapon {
    private static final float[] DAMAGE_VALUES = new float[]{6.0f, 7.5f, 9.0f};
    private static final int[] DURABILITY_VALUES = new int[]{1000, 2000, 3000};
    private static final int COOLDOWN = 60;
    private static final float BASE_ACCURACY = 0.08f;
    private static final float BASE_VELOCITY = 2.5f;
    private static final float GRAVITY = 0.0f;

    public TieredFlintlockPistol(String name, Item.ToolMaterial material, Item fragmentItem) {
        super(name, 3, DURABILITY_VALUES, DAMAGE_VALUES, fragmentItem, ModWeapons.BULLET, 0.08f, false, 2.5f, 0.0f);
    }

    @Override
    protected float getMeleeDamage() {
        return 2.0f;
    }

    @Override
    protected ActionResult<ItemStack> fireWeaponWithTier(World world, EntityPlayer player, EnumHand hand, ItemStack stack, int tier) {
        if (!world.field_72995_K) {
            if (player instanceof EntityPlayerMP) {
                ModPackets.NETWORK.sendToAll((IMessage)new PlayCustomSoundPacket(PlayCustomSoundPacket.CustomSoundEnum.WEAPONS_FLINTLOCK_RIFLE, 1.0f, 1.0f + (float)tier * 0.1f, false, 0, player.field_70165_t, player.field_70163_u, player.field_70161_v));
            }
            float rotationPitch = player.field_70125_A;
            float rotationYaw = player.field_70177_z;
            float yawRadians = rotationYaw * ((float)Math.PI / 180);
            float pitchRadians = rotationPitch * ((float)Math.PI / 180);
            float cosYaw = MathHelper.func_76134_b((float)(-yawRadians - (float)Math.PI));
            float sinYaw = MathHelper.func_76126_a((float)(-yawRadians - (float)Math.PI));
            float cosPitch = -MathHelper.func_76134_b((float)(-pitchRadians));
            float sinPitch = MathHelper.func_76126_a((float)(-pitchRadians));
            float accuracy = this.getAdjustedAccuracy(tier);
            float randomX = (world.field_73012_v.nextFloat() - 0.5f) * accuracy;
            float randomY = (world.field_73012_v.nextFloat() - 0.5f) * accuracy;
            float randomZ = (world.field_73012_v.nextFloat() - 0.5f) * accuracy;
            float velocityFactor = this.getAdjustedVelocityFactor(tier);
            double velX = (sinYaw * cosPitch + randomX) * velocityFactor;
            double velY = (sinPitch + randomY) * velocityFactor;
            double velZ = (cosYaw * cosPitch + randomZ) * velocityFactor;
            float damageAmount = this.damages[tier];
            float proximityRange = 2.0f;
            Vec3d eyePos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            Vec3d lookVec = player.func_70040_Z();
            Vec3d scaledLookVec = new Vec3d(lookVec.field_72450_a * (double)proximityRange, lookVec.field_72448_b * (double)proximityRange, lookVec.field_72449_c * (double)proximityRange);
            Vec3d targetPos = eyePos.func_178787_e(scaledLookVec);
            RayTraceResult rayTrace = world.func_147447_a(eyePos, targetPos, false, true, false);
            boolean hitEntity = false;
            if (rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) {
                List entities = world.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * (double)proximityRange, lookVec.field_72448_b * (double)proximityRange, lookVec.field_72449_c * (double)proximityRange).func_186662_g(1.0));
                double closestDistance = proximityRange * proximityRange;
                Entity hitEntityObj = null;
                for (Entity entity : entities) {
                    double distanceSq;
                    AxisAlignedBB axisalignedbb;
                    RayTraceResult potentialHit;
                    if (!entity.func_70067_L() || (potentialHit = (axisalignedbb = entity.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(eyePos, targetPos)) == null || !((distanceSq = eyePos.func_72436_e(potentialHit.field_72307_f)) < closestDistance)) continue;
                    hitEntityObj = entity;
                    closestDistance = distanceSq;
                }
                if (hitEntityObj != null) {
                    hitEntityObj.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damageAmount);
                    hitEntity = true;
                    world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, hitEntityObj.field_70165_t, hitEntityObj.field_70163_u + (double)(hitEntityObj.field_70131_O / 2.0f), hitEntityObj.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (!hitEntity) {
                double posX = player.field_70165_t;
                double posY = player.field_70163_u + (double)player.func_70047_e() - 0.1;
                double posZ = player.field_70161_v;
                EntityBullet bullet = new EntityBullet(world, (EntityLivingBase)player, damageAmount, tier, false, this.usesParabolicPath(), this.getGravity());
                bullet.func_70107_b(posX, posY, posZ);
                bullet.func_70186_c(velX, velY, velZ, velocityFactor, 0.0f);
                bullet.setWeaponType("pistol");
                bullet.setIgnoreEntity((Entity)player);
                bullet.setMaxTicksAlive(60);
                world.func_72838_d((Entity)bullet);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            float knockbackStrength = 0.1f + (float)tier * 0.05f;
            player.func_70024_g(-lookVec.field_72450_a * (double)knockbackStrength, 0.05, -lookVec.field_72449_c * (double)knockbackStrength);
            player.field_70133_I = true;
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (player.func_70093_af() && player.field_70170_p.field_72995_K) {
            return true;
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public int getCooldown() {
        return 60;
    }

    @Override
    public float getRange() {
        return 16.0f;
    }
}

