/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.weapons.shooting;

import fr.minepiece.common.entity.projectile.EntityExplosiveProjectile;
import fr.minepiece.common.init.ModWeapons;
import fr.minepiece.common.items.weapons.shooting.TieredShootingWeapon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TieredBazooka
extends TieredShootingWeapon {
    private static final float[] DAMAGE_VALUES = new float[]{9.0f, 10.5f, 12.0f};
    private static final int[] DURABILITY_VALUES = new int[]{1000, 2000, 3000};
    private static final int COOLDOWN = 400;
    private static final float BASE_ACCURACY = 0.06f;
    private static final float BASE_VELOCITY = 1.5f;
    private static final float GRAVITY = 0.05f;
    private static final float[] EXPLOSION_SIZE = new float[]{4.0f, 5.0f, 7.0f};

    public TieredBazooka(String name, Item.ToolMaterial material, Item fragmentItem) {
        super(name, 3, DURABILITY_VALUES, DAMAGE_VALUES, fragmentItem, ModWeapons.BAZOOKA_SHELL, 0.06f, true, 1.5f, 0.05f);
    }

    @Override
    protected float getMeleeDamage() {
        return 4.0f;
    }

    @Override
    protected ActionResult<ItemStack> fireWeaponWithTier(World world, EntityPlayer player, EnumHand hand, ItemStack stack, int tier) {
        if (!world.field_72995_K) {
            float rotationPitch = player.field_70125_A;
            float rotationYaw = player.field_70177_z;
            float yawRadians = rotationYaw * ((float)Math.PI / 180);
            float pitchRadians = rotationPitch * ((float)Math.PI / 180);
            float cosYaw = MathHelper.func_76134_b((float)(-yawRadians - (float)Math.PI));
            float sinYaw = MathHelper.func_76126_a((float)(-yawRadians - (float)Math.PI));
            float cosPitch = -MathHelper.func_76134_b((float)(-pitchRadians));
            float sinPitch = MathHelper.func_76126_a((float)(-pitchRadians));
            float accuracy = this.getAdjustedAccuracy(tier);
            float randomX = (world.field_73012_v.nextFloat() - 0.5f) * accuracy;
            float randomY = (world.field_73012_v.nextFloat() - 0.5f) * accuracy;
            float randomZ = (world.field_73012_v.nextFloat() - 0.5f) * accuracy;
            float velocityFactor = this.getAdjustedVelocityFactor(tier);
            double velX = (sinYaw * cosPitch + randomX) * velocityFactor;
            double velY = (sinPitch + randomY) * velocityFactor;
            double velZ = (cosYaw * cosPitch + randomZ) * velocityFactor;
            double posX = player.field_70165_t;
            double posY = player.field_70163_u + (double)player.func_70047_e() - 0.1;
            double posZ = player.field_70161_v;
            EntityExplosiveProjectile explosive = new EntityExplosiveProjectile(world, (EntityLivingBase)player, this.damages[tier], tier, EXPLOSION_SIZE[tier], this.usesParabolicPath(), this.getGravity());
            explosive.func_70107_b(posX, posY, posZ);
            explosive.func_70186_c(velX, velY, velZ, velocityFactor, 0.0f);
            explosive.setWeaponType("bazooka");
            explosive.setIgnoreEntity((Entity)player);
            int maxTicks = 20 + tier * 5;
            explosive.setMaxTicksAlive(maxTicks);
            boolean breakBlocks = player.func_184812_l_() || tier >= 2;
            explosive.setBreakBlocks(breakBlocks);
            world.func_72838_d((Entity)explosive);
            stack.func_77972_a(1, (EntityLivingBase)player);
            float knockbackStrength = 0.7f + (float)tier * 0.5f;
            Vec3d lookVec = player.func_70040_Z();
            player.func_70024_g(-lookVec.field_72450_a * (double)knockbackStrength, 0.1, -lookVec.field_72449_c * (double)knockbackStrength);
            player.field_70133_I = true;
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public int getCooldown() {
        return 400;
    }

    @Override
    public float getRange() {
        return 28.0f;
    }
}

