/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.weapons.shooting;

import fr.minepiece.MinePiece;
import fr.minepiece.common.init.ModItems;
import fr.minepiece.common.items.ICooldownWeapon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class BaseItemShooting
extends Item
implements ICooldownWeapon {
    protected final Item ammoItem;
    protected final int durability;
    protected final float baseDamage;
    protected final float baseAccuracy;
    protected final boolean hasParabolicPath;
    protected final float velocityFactor;
    protected final float gravity;

    public BaseItemShooting(String name, Item ammoItem, int durability, float baseDamage, float baseAccuracy, boolean hasParabolicPath, float velocityFactor, float gravity) {
        this.ammoItem = ammoItem;
        this.durability = durability;
        this.baseDamage = baseDamage;
        this.baseAccuracy = baseAccuracy;
        this.hasParabolicPath = hasParabolicPath;
        this.velocityFactor = velocityFactor;
        this.gravity = gravity;
        ((Item)this.setRegistryName(name)).func_77655_b(name);
        this.func_77637_a(MinePiece.WEAPONS);
        this.func_77656_e(durability);
        this.func_77625_d(1);
    }

    protected abstract ActionResult<ItemStack> fireWeapon(World var1, EntityPlayer var2, EnumHand var3, ItemStack var4);

    protected boolean consumeAmmo(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (itemStack.func_77973_b() != this.ammoItem) continue;
            itemStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    protected boolean consumePowder(EntityPlayer player, int durabilityReduction) {
        if (player.func_184812_l_()) {
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            int maxDamage;
            int currentDamage;
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (itemStack.func_77973_b() != ModItems.SAC_POUDRE || (currentDamage = itemStack.func_77952_i()) + durabilityReduction > (maxDamage = itemStack.func_77958_k())) continue;
            itemStack.func_77972_a(durabilityReduction, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    protected boolean consumePowder(EntityPlayer player) {
        return this.consumePowder(player, 1);
    }

    private boolean checkHasAmmo(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (itemStack.func_77973_b() != this.ammoItem) continue;
            return true;
        }
        return false;
    }

    private boolean checkHasPowder(EntityPlayer player, int durabilityNeeded) {
        if (player.func_184812_l_()) {
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            int maxDamage;
            int currentDamage;
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (itemStack.func_77973_b() != ModItems.SAC_POUDRE || (currentDamage = itemStack.func_77952_i()) + durabilityNeeded > (maxDamage = itemStack.func_77958_k())) continue;
            return true;
        }
        return false;
    }

    private boolean checkHasPowder(EntityPlayer player) {
        return this.checkHasPowder(player, 1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && this.cooldownPassed(stack)) {
            if (this.consumeAmmo(playerIn) && this.consumePowder(playerIn)) {
                this.resetCooldown(stack);
                this.applyVisualCooldown(playerIn, stack);
                return this.fireWeapon(worldIn, playerIn, handIn, stack);
            }
            boolean hasAmmo = this.checkHasAmmo(playerIn);
            boolean hasPowder = this.checkHasPowder(playerIn);
            if (!hasAmmo) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.no_ammo", new Object[]{new TextComponentTranslation(this.ammoItem.func_77658_a() + ".name", new Object[0]).func_150254_d()}));
            }
            if (!hasPowder) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.no_powder", new Object[]{new TextComponentTranslation(ModItems.SAC_POUDRE.func_77658_a() + ".name", new Object[0]).func_150254_d()}));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void damageWeapon(ItemStack stack, EntityPlayer player) {
        stack.func_77972_a(1, (EntityLivingBase)player);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(2, attacker);
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() >= stack.func_77958_k() && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (!worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.weapon_break", new Object[]{new TextComponentTranslation(this.func_77658_a() + ".name", new Object[0]).func_150254_d()}));
            }
            stack.func_190918_g(1);
        }
    }

    public float getRange() {
        return 24.0f;
    }

    public boolean usesParabolicPath() {
        return this.hasParabolicPath;
    }

    public float getVelocityFactor() {
        return this.velocityFactor;
    }

    public float getGravity() {
        return this.gravity;
    }

    public float getAccuracy() {
        return this.baseAccuracy;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }
}

