/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.minepiece.MinePiece;
import fr.minepiece.common.items.INBTProvider;
import fr.minepiece.common.items.weapons.BaseItemSword;
import fr.minepiece.common.items.weapons.IKnockbackWeapon;
import fr.minepiece.common.items.weapons.IReachWeapon;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TieredItemSword
extends BaseItemSword
implements INBTProvider,
IReachWeapon,
IKnockbackWeapon {
    private final int maxTier;
    private final int[] durabilities;
    private final float[] attackDamages;
    private final float[] attackSpeeds;
    private final Item fragmentItem;
    private final int weaponType;
    private float reach = 0.0f;
    private int knockbackLevel = 0;

    public TieredItemSword(String name, Item.ToolMaterial material, int maxTier, int[] durabilities, float[] attackDamages, float[] attackSpeeds, Item fragmentItem, float reach) {
        this(name, material, maxTier, durabilities, attackDamages, attackSpeeds, fragmentItem);
        this.reach = reach;
    }

    public TieredItemSword(String name, Item.ToolMaterial material, int maxTier, int[] durabilities, float[] attackDamages, float[] attackSpeeds, Item fragmentItem) {
        super(name, material);
        this.maxTier = maxTier;
        this.durabilities = durabilities;
        this.attackDamages = attackDamages;
        this.attackSpeeds = attackSpeeds;
        this.fragmentItem = fragmentItem;
        if (name.contains("lance")) {
            this.weaponType = 5;
            this.reach = 0.4f;
        } else if (name.contains("mace")) {
            this.weaponType = 4;
            this.knockbackLevel = 2;
        } else if (name.contains("dagger")) {
            this.weaponType = 7;
            this.reach = -0.3f;
        } else {
            this.weaponType = name.contains("trident") ? 6 : (name.contains("katana") ? 1 : (name.contains("longsword") ? 2 : (name.contains("battleaxe") ? 3 : 0)));
        }
        this.func_77637_a(MinePiece.WEAPONS);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int getWeaponType() {
        return this.weaponType;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        int tier = this.getTier(stack);
        return this.durabilities[tier];
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77951_h();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)this.getMaxDamage(stack);
    }

    public boolean func_77614_k() {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int tier = 0; tier < this.maxTier; ++tier) {
                ItemStack stack = this.createTieredSword(tier);
                items.add((Object)stack);
            }
        }
    }

    public ItemStack createTieredSword(int tier) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Tier", tier);
        stack.func_77982_d(nbt);
        return stack;
    }

    public int getTier(ItemStack stack) {
        if (stack.func_77942_o()) {
            return this.getTier(stack.func_77978_p());
        }
        return 0;
    }

    public int getTier(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Tier")) {
            return nbt.func_74762_e("Tier");
        }
        return 0;
    }

    public int getDisplayTier(ItemStack stack) {
        return this.getTier(stack) + 1;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        if (this.weaponType == 6 && attacker.func_70090_H()) {
            float bonusDamage = 2.0f;
            if (attacker instanceof EntityPlayer) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), bonusDamage);
            } else {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacker), bonusDamage);
            }
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void handleWeaponBreak(ItemStack stack, EntityPlayer player) {
        ItemStack fragmentStack;
        int tier = this.getTier(stack);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.weapon_break", new Object[]{new TextComponentTranslation(this.func_77658_a() + ".name", new Object[0]).func_150254_d()}));
        if (this.fragmentItem != null && !player.field_71071_by.func_70441_a(fragmentStack = new ItemStack(this.fragmentItem, 1, tier))) {
            player.func_71019_a(fragmentStack, false);
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            int tier = this.getTier(stack);
            float attackDamage = this.attackDamages[tier];
            float attackSpeed = this.attackSpeeds[tier];
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f + (double)attackSpeed, 0));
        }
        return multimap;
    }

    public String func_77667_c(ItemStack stack) {
        int tier = this.getTier(stack);
        return super.func_77658_a() + ".tier" + tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        TextFormatting color;
        int tier = this.getTier(stack);
        int displayTier = this.getDisplayTier(stack);
        switch (displayTier) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.AQUA;
                break;
            }
            case 3: {
                color = TextFormatting.GREEN;
                break;
            }
            case 4: {
                color = TextFormatting.LIGHT_PURPLE;
                break;
            }
            case 5: {
                color = TextFormatting.GOLD;
                break;
            }
            default: {
                color = TextFormatting.WHITE;
            }
        }
        tooltip.add(color + "Tier " + displayTier);
        int maxDamage = this.getMaxDamage(stack);
        int currentDamage = stack.func_77952_i();
        int durabilityLeft = maxDamage - currentDamage;
        tooltip.add(TextFormatting.GRAY + "Durabilit\u00e9: " + durabilityLeft + " / " + maxDamage);
        if (this.weaponType == 5) {
            tooltip.add(TextFormatting.BLUE + "Port\u00e9e d'attaque: " + this.reach + " blocs");
        } else if (this.weaponType == 7) {
            tooltip.add(TextFormatting.BLUE + "Port\u00e9e d'attaque: " + this.reach + " blocs");
        } else if (this.weaponType == 4) {
            tooltip.add(TextFormatting.BLUE + "Recul: Niveau " + this.knockbackLevel);
        } else if (this.weaponType == 6) {
            tooltip.add(TextFormatting.BLUE + "D\u00e9g\u00e2ts dans l'eau: +" + 2.0f);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving instanceof EntityPlayer && stack.func_77952_i() >= this.getMaxDamage(stack) - 1) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            EnumHand hand = EnumHand.MAIN_HAND;
            if (player.func_184586_b(EnumHand.OFF_HAND) == stack) {
                hand = EnumHand.OFF_HAND;
            }
            ItemStack brokenStack = stack.func_77946_l();
            player.func_184611_a(hand, ItemStack.field_190927_a);
            this.handleWeaponBreak(brokenStack, player);
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    @Override
    public String getVariantName(NBTTagCompound nbt) {
        return "tier_" + this.getTier(nbt);
    }

    @Override
    public double getReach(ItemStack stack, EntityPlayer player) {
        return this.reach;
    }

    @Override
    public float getKnockback(ItemStack stack, EntityLivingBase attacker, EntityLivingBase target) {
        return this.knockbackLevel;
    }
}

