/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.weapons;

import fr.minepiece.MinePiece;
import fr.minepiece.common.entity.EntityDynamite;
import fr.minepiece.common.items.BaseItem;
import fr.minepiece.common.utils.CooldownUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDynamite
extends BaseItem {
    public static final String[] VARIANTS = new String[]{"red", "orange", "yellow", "green", "blue", "aqua", "pink", "purple"};
    private static final long BASE_COOLDOWN_DURATION = 5000L;
    private static final long COOLDOWN_INCREMENT_PER_TIER = 1000L;

    public ItemDynamite() {
        super("dynamite", MinePiece.ITEMS);
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77637_a(MinePiece.WEAPONS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta < VARIANTS.length; ++meta) {
                items.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    private String getCooldownId(int tier) {
        return "item.dynamite." + VARIANTS[tier];
    }

    private long getCooldownDuration(int tier) {
        return 5000L + (long)tier * 1000L;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        String cooldownId;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        int tier = itemstack.func_77960_j();
        if (tier < 0 || tier >= VARIANTS.length) {
            tier = 0;
        }
        if (!CooldownUtils.cooldownPassed(playerIn, cooldownId = this.getCooldownId(tier))) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        long cooldownDuration = this.getCooldownDuration(tier);
        CooldownUtils.setCooldown(playerIn, cooldownId, this, cooldownDuration);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EntityDynamite entityDynamite = new EntityDynamite(worldIn, (EntityLivingBase)playerIn, tier);
            entityDynamite.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_72838_d((Entity)entityDynamite);
        }
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta < 0 || meta >= VARIANTS.length) {
            meta = 0;
        }
        return super.func_77658_a() + "_" + VARIANTS[meta];
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int tier = stack.func_77960_j();
        if (tier < 0 || tier >= VARIANTS.length) {
            tier = 0;
        }
        tooltip.add("\u00a77" + new TextComponentTranslation("item.dynamite.tooltip", new Object[]{++tier}).func_150254_d());
    }
}

