/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs.medic.healing;

import fr.minepiece.MinePiece;
import fr.minepiece.common.capability.knockout.IKOState;
import fr.minepiece.common.capability.knockout.KOStateStorage;
import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import fr.minepiece.common.handlers.PlayerKOHandler;
import fr.minepiece.common.items.BaseItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MedkitItem
extends BaseItem {
    private static final int USE_DURATION_SECONDS = 10;
    private static final int COOLDOWN_SECONDS = 60;
    private static final double TARGET_RANGE = 3.0;
    private static final String NBT_TARGET_KEY = "MedkitTargetID";

    public MedkitItem(String name) {
        super(name, MinePiece.ITEMS, 1);
    }

    public int func_77626_a(ItemStack stack) {
        return 200;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        IMinePieceCooldown cooldowns;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && (cooldowns = (IMinePieceCooldown)playerIn.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null)) != null) {
            long currentTime = System.currentTimeMillis();
            long cooldownEndTime = cooldowns.getCooldown(this.getRegistryName().toString());
            if (cooldownEndTime > currentTime) {
                long remaining = (cooldownEndTime - currentTime + 999L) / 1000L;
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.medkit.cooldown", new Object[]{remaining}), true);
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
        }
        EntityPlayer target = this.getEntityInSight(playerIn, worldIn, 3.0);
        if (!worldIn.field_72995_K) {
            if (target instanceof EntityPlayer && target != playerIn) {
                EntityPlayer targetPlayer = target;
                if (PlayerKOHandler.isPlayerInKO(targetPlayer)) {
                    NBTTagCompound nbt = itemstack.func_77978_p();
                    if (nbt == null) {
                        nbt = new NBTTagCompound();
                        itemstack.func_77982_d(nbt);
                    }
                    nbt.func_74768_a(NBT_TARGET_KEY, target.func_145782_y());
                    playerIn.func_184598_c(handIn);
                    worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187713_n, SoundCategory.PLAYERS, 0.5f, 0.9f);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
                }
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.medkit.target_not_ko", new Object[]{targetPlayer.func_70005_c_()}), true);
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.medkit.no_valid_target", new Object[0]), true);
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (target instanceof EntityPlayer && target != playerIn) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer) || worldIn.field_72995_K) {
            return stack;
        }
        EntityPlayer playerUser = (EntityPlayer)entityLiving;
        EntityPlayer targetPlayer = null;
        boolean revivedSomeone = false;
        NBTTagCompound nbt = stack.func_77978_p();
        int targetId = -1;
        if (nbt == null || !nbt.func_150297_b(NBT_TARGET_KEY, 99)) {
            return stack;
        }
        targetId = nbt.func_74762_e(NBT_TARGET_KEY);
        Entity targetEntity = worldIn.func_73045_a(targetId);
        if (targetEntity instanceof EntityPlayer && targetEntity != playerUser && targetEntity.func_70089_S()) {
            targetPlayer = (EntityPlayer)targetEntity;
            if (playerUser.func_70068_e((Entity)targetPlayer) <= 9.9) {
                if (PlayerKOHandler.isPlayerInKO(targetPlayer)) {
                    IKOState koState = (IKOState)targetPlayer.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
                    IPlayerModifications playerModifications = (IPlayerModifications)targetPlayer.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
                    if (koState != null && playerModifications != null) {
                        koState.setKOState(false);
                        playerModifications.setPose("default");
                        if (targetPlayer instanceof EntityPlayerMP) {
                            koState.clientSync((EntityPlayerMP)targetPlayer);
                            playerModifications.clientSync((EntityPlayerMP)targetPlayer);
                            PlayerKOHandler.removeNaturalKOEffects((EntityPlayerMP)targetPlayer);
                        }
                        revivedSomeone = true;
                        worldIn.func_184148_a(null, targetPlayer.field_70165_t, targetPlayer.field_70163_u, targetPlayer.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.2f);
                        worldIn.func_184148_a(null, targetPlayer.field_70165_t, targetPlayer.field_70163_u, targetPlayer.field_70161_v, SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 0.8f, 1.0f);
                        playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.medkit.revive.success", new Object[]{targetPlayer.func_70005_c_()}));
                        targetPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.medkit.revived", new Object[]{playerUser.func_70005_c_()}));
                    } else {
                        playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.medkit.error.capability", new Object[]{targetPlayer.func_70005_c_()}));
                    }
                } else {
                    playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.medkit.target_not_ko", new Object[]{targetPlayer.func_70005_c_()}));
                }
            } else {
                playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.medkit.target.outofrange", new Object[]{targetPlayer.func_70005_c_()}));
            }
        } else {
            playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.medkit.target.lost", new Object[0]));
        }
        if (revivedSomeone) {
            IMinePieceCooldown cooldowns = (IMinePieceCooldown)playerUser.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
            if (cooldowns != null) {
                cooldowns.setCooldown(this.getRegistryName().toString(), System.currentTimeMillis() + 60000L);
            }
            if (!playerUser.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if (nbt != null) {
            nbt.func_82580_o(NBT_TARGET_KEY);
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        NBTTagCompound nbt;
        if (!worldIn.field_72995_K && entityLiving instanceof EntityPlayer && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b(NBT_TARGET_KEY)) {
            nbt.func_82580_o(NBT_TARGET_KEY);
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TextComponentTranslation("tooltip.medkit.info.revive", new Object[0]).func_150254_d());
        tooltip.add(new TextComponentTranslation("tooltip.medkit.info.duration", new Object[]{10}).func_150254_d());
        tooltip.add(new TextComponentTranslation("tooltip.medkit.info.range", new Object[]{String.format("%.1f", 3.0)}).func_150254_d());
        tooltip.add(new TextComponentTranslation("tooltip.medkit.info.cooldown", new Object[]{60}).func_150254_d());
    }

    @Nullable
    private EntityPlayer getEntityInSight(EntityPlayer player, World world, double range) {
        Vec3d eyePos = player.func_174824_e(1.0f);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = eyePos.func_178787_e(lookVec.func_186678_a(range));
        Entity pointedEntity = null;
        double closestDistSq = range * range;
        AxisAlignedBB searchBox = player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range).func_72314_b(1.0, 1.0, 1.0);
        List list = world.func_72839_b((Entity)player, searchBox);
        for (Entity entityCheck : list) {
            double distSq;
            if (!entityCheck.func_70067_L() || !(entityCheck instanceof EntityPlayer) || entityCheck == player) continue;
            AxisAlignedBB entityBox = entityCheck.func_174813_aQ().func_186662_g((double)entityCheck.func_70111_Y());
            RayTraceResult intercept = entityBox.func_72327_a(eyePos, endVec);
            if (entityBox.func_72318_a(eyePos)) {
                if (!(0.0 < closestDistSq)) continue;
                pointedEntity = entityCheck;
                closestDistSq = 0.0;
                continue;
            }
            if (intercept == null || !((distSq = eyePos.func_72436_e(intercept.field_72307_f)) < closestDistSq)) continue;
            pointedEntity = entityCheck;
            closestDistSq = distSq;
        }
        return (EntityPlayer)pointedEntity;
    }
}

