/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs.medic.healing;

import fr.minepiece.MinePiece;
import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import fr.minepiece.common.items.BaseItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class InstantHealItem
extends BaseItem {
    private final float healAmount;
    private final int useTime;
    private static final int COOLDOWN = 5;
    private static final double TARGET_RANGE = 6.0;
    private static final String NBT_TARGET_KEY = "HealTargetID";

    public InstantHealItem(String name, float healAmount, int useTime) {
        super(name, MinePiece.ITEMS);
        this.healAmount = healAmount;
        this.useTime = useTime;
        this.func_77625_d(16);
    }

    public int func_77626_a(ItemStack stack) {
        return this.useTime * 20;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        EntityPlayer target;
        boolean targetingPlayer;
        IMinePieceCooldown cooldowns;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        boolean onCooldown = false;
        if (!worldIn.field_72995_K && (cooldowns = (IMinePieceCooldown)playerIn.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null)) != null) {
            long currentTime = System.currentTimeMillis();
            long cooldownEndTime = cooldowns.getCooldown(this.getRegistryName().toString());
            if (cooldownEndTime > currentTime) {
                onCooldown = true;
                long remaining = (cooldownEndTime - currentTime + 999L) / 1000L;
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.instanthealitem.cooldown", new Object[]{remaining}), true);
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
        }
        boolean bl = targetingPlayer = (target = this.getEntityInSight(playerIn, worldIn, 6.0)) instanceof EntityPlayer && target != playerIn;
        if (!worldIn.field_72995_K) {
            if (targetingPlayer) {
                NBTTagCompound nbt = itemstack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                    itemstack.func_77982_d(nbt);
                }
                nbt.func_74768_a(NBT_TARGET_KEY, target.func_145782_y());
            } else if (itemstack.func_77942_o()) {
                itemstack.func_77978_p().func_82580_o(NBT_TARGET_KEY);
                if (itemstack.func_77978_p().func_82582_d()) {
                    itemstack.func_77982_d(null);
                }
            }
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer) || worldIn.field_72995_K) {
            return stack;
        }
        EntityPlayer playerUser = (EntityPlayer)entityLiving;
        EntityPlayer targetPlayer = null;
        boolean healedSomeone = false;
        NBTTagCompound nbt = stack.func_77978_p();
        int targetId = -1;
        if (nbt != null && nbt.func_150297_b(NBT_TARGET_KEY, 99)) {
            targetId = nbt.func_74762_e(NBT_TARGET_KEY);
        }
        if (targetId != -1) {
            Entity targetEntity = worldIn.func_73045_a(targetId);
            if (targetEntity instanceof EntityPlayer && targetEntity.func_70089_S()) {
                targetPlayer = (EntityPlayer)targetEntity;
                targetPlayer.func_70691_i(this.healAmount);
                healedSomeone = true;
                worldIn.func_184148_a(null, targetPlayer.field_70165_t, targetPlayer.field_70163_u, targetPlayer.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.8f, 1.0f + worldIn.field_73012_v.nextFloat() * 0.2f);
                playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.instanthealitem.heal.target.success", new Object[]{targetPlayer.func_70005_c_(), String.format("%.1f", Float.valueOf(this.healAmount))}));
                targetPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.instanthealitem.heal.received", new Object[]{playerUser.func_70005_c_(), String.format("%.1f", Float.valueOf(this.healAmount))}));
            } else {
                playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.instanthealitem.heal.target.lost", new Object[0]));
            }
            if (nbt != null) {
                nbt.func_82580_o(NBT_TARGET_KEY);
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
        } else {
            targetPlayer = playerUser;
            targetPlayer.func_70691_i(this.healAmount);
            healedSomeone = true;
            worldIn.func_184148_a(null, playerUser.field_70165_t, playerUser.field_70163_u, playerUser.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.8f, 1.0f + worldIn.field_73012_v.nextFloat() * 0.2f);
            playerUser.func_145747_a((ITextComponent)new TextComponentTranslation("message.instanthealitem.heal.self.success", new Object[]{String.format("%.1f", Float.valueOf(this.healAmount))}));
        }
        if (healedSomeone) {
            IMinePieceCooldown cooldowns = (IMinePieceCooldown)playerUser.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
            if (cooldowns != null) {
                cooldowns.setCooldown(this.getRegistryName().toString(), System.currentTimeMillis() + 5000L);
            }
            if (!playerUser.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TextComponentTranslation("tooltip.instantheal.heal", new Object[]{String.format("%.1f", Float.valueOf(this.healAmount))}).func_150254_d());
        tooltip.add(new TextComponentTranslation("tooltip.instantheal.duration", new Object[]{this.useTime}).func_150254_d());
        tooltip.add(new TextComponentTranslation("tooltip.instantheal.cooldown", new Object[]{5}).func_150254_d());
    }

    @Nullable
    private EntityPlayer getEntityInSight(EntityPlayer player, World world, double range) {
        Vec3d eyePos = player.func_174824_e(1.0f);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = eyePos.func_178787_e(lookVec.func_186678_a(range));
        Entity pointedEntity = null;
        Vec3d hitVec = null;
        double closestDistSq = range * range;
        AxisAlignedBB searchBox = player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range).func_72314_b(1.0, 1.0, 1.0);
        List list = world.func_72839_b((Entity)player, searchBox);
        for (Entity entityCheck : list) {
            double distSq;
            if (!entityCheck.func_70067_L() || !(entityCheck instanceof EntityPlayer) || entityCheck == player) continue;
            AxisAlignedBB entityBox = entityCheck.func_174813_aQ().func_186662_g((double)entityCheck.func_70111_Y());
            RayTraceResult intercept = entityBox.func_72327_a(eyePos, endVec);
            if (entityBox.func_72318_a(eyePos)) {
                if (!(0.0 < closestDistSq)) continue;
                pointedEntity = entityCheck;
                hitVec = intercept == null ? eyePos : intercept.field_72307_f;
                closestDistSq = 0.0;
                continue;
            }
            if (intercept == null || !((distSq = eyePos.func_72436_e(intercept.field_72307_f)) < closestDistSq)) continue;
            pointedEntity = entityCheck;
            hitVec = intercept.field_72307_f;
            closestDistSq = distSq;
        }
        return (EntityPlayer)pointedEntity;
    }
}

