/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs.cook;

import fr.minepiece.MinePiece;
import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.capability.thirst.ThirstProvider;
import fr.minepiece.common.init.ModBeverages;
import fr.minepiece.common.items.BeverageItem;
import fr.minepiece.common.items.IMetaProvider;
import fr.minepiece.common.items.jobs.cook.CookBeverageItem;
import fr.minepiece.common.utils.CooldownUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GlassItem
extends Item
implements IMetaProvider {
    public static final int EMPTY_META = 0;
    public static final int RED_WINE_META = 1;
    private static final Map<Item, Integer> DRINK_TO_GLASS_META = new HashMap<Item, Integer>();
    private static final String[] VARIANTS = new String[]{"empty", "red_wine"};
    private static final long FILL_COOLDOWN = 500L;
    private static final String FILL_COOLDOWN_ID = "glass_fill";

    public GlassItem() {
        this.setRegistryName("verre_boisson");
        this.func_77655_b("verre_boisson");
        this.func_77637_a(MinePiece.ITEMS);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(16);
        this.initDrinkToGlassMappings();
    }

    private void initDrinkToGlassMappings() {
        DRINK_TO_GLASS_META.put(ModBeverages.BOUTEILLE_VIN_ROUGE, 1);
    }

    public static boolean canPourIntoGlass(Item sourceItem) {
        return DRINK_TO_GLASS_META.containsKey(sourceItem);
    }

    public static int getGlassMetaForDrink(Item sourceItem) {
        return DRINK_TO_GLASS_META.getOrDefault(sourceItem, 0);
    }

    public static Item getCorrespondingDrinkItem(int meta) {
        for (Map.Entry<Item, Integer> entry : DRINK_TO_GLASS_META.entrySet()) {
            if (entry.getValue() != meta) continue;
            return entry.getKey();
        }
        return null;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77960_j() > 0) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && stack.func_77960_j() == 0) {
            return this.handleFillingGlass(world, player, hand, stack);
        }
        if (stack.func_77960_j() > 0) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private ActionResult<ItemStack> handleFillingGlass(World world, EntityPlayer player, EnumHand hand, ItemStack glassStack) {
        ItemStack offhandItem = player.func_184592_cb();
        if (offhandItem.func_190926_b()) {
            return new ActionResult(EnumActionResult.PASS, (Object)glassStack);
        }
        Item offhandItemType = offhandItem.func_77973_b();
        if (GlassItem.canPourIntoGlass(offhandItemType)) {
            if (!CooldownUtils.cooldownPassed(player, FILL_COOLDOWN_ID)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)glassStack);
            }
            int newMeta = GlassItem.getGlassMetaForDrink(offhandItemType);
            ItemStack filledGlass = new ItemStack((Item)this, 1, newMeta);
            if (!player.field_71075_bZ.field_75098_d) {
                if (offhandItemType instanceof CookBeverageItem) {
                    CookBeverageItem beverage = (CookBeverageItem)offhandItemType;
                    int usesLeft = beverage.getUsesLeft(offhandItem);
                    if (usesLeft > 1) {
                        beverage.setUsesLeft(offhandItem, usesLeft - 1);
                    } else if (offhandItemType instanceof BeverageItem) {
                        BeverageItem beverageItem = (BeverageItem)offhandItemType;
                        ItemStack returnItem = beverageItem.getReturnItem();
                        offhandItem = returnItem.func_77946_l();
                        player.func_184611_a(EnumHand.OFF_HAND, offhandItem);
                    } else {
                        offhandItem.func_190918_g(1);
                    }
                } else {
                    offhandItem.func_190918_g(1);
                }
            }
            CooldownUtils.setCooldown(player, FILL_COOLDOWN_ID, this, 500L);
            if (glassStack.func_190916_E() == 1) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)filledGlass);
            }
            glassStack.func_190918_g(1);
            if (!player.field_71071_by.func_70441_a(filledGlass)) {
                player.func_71019_a(filledGlass, false);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)glassStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)glassStack);
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77960_j() > 0) {
            return 32;
        }
        return 0;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int meta = stack.func_77960_j();
            if (meta > 0) {
                Item drinkItem = GlassItem.getCorrespondingDrinkItem(meta);
                if (drinkItem != null && meta == 1) {
                    IThirst thirst = (IThirst)player.getCapability(ThirstProvider.THIRST_CAPABILITY, null);
                    if (thirst != null) {
                        thirst.drink(4.0f, 0.2f);
                    }
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 0));
                }
                ItemStack emptyGlass = new ItemStack((Item)this, 1, 0);
                stack.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(emptyGlass)) {
                    player.func_71019_a(emptyGlass, false);
                }
                return stack;
            }
        }
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            for (int meta : DRINK_TO_GLASS_META.values()) {
                items.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        int meta = stack.func_77960_j();
        if (meta > 0) {
            if (meta == 1) {
                tooltip.add("\u00a76Contenu: \u00a7eVin Rouge");
            }
        } else {
            tooltip.add("\u00a77Verre Vide");
            tooltip.add("\u00a78Shift + clic droit avec une bouteille");
            tooltip.add("\u00a78dans votre main secondaire pour remplir");
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item.minepiece.verre_boisson";
    }

    @Override
    public String getVariantName(int meta) {
        if (meta < 0 || meta >= VARIANTS.length) {
            meta = 0;
        }
        return VARIANTS[meta];
    }
}

