/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs.cook;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.items.jobs.JobToolItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CookToolItem
extends JobToolItem {
    private final boolean canHarvestFruits;
    private final boolean canHarvestVegetables;
    private final SoundEvent harvestSound;

    public CookToolItem(String name, int durability, int xpBonus, int minLevel) {
        super(name, durability, xpBonus, minLevel, MinePieceJobs.COOK, 1.0f, MinePiece.ITEMS);
        this.canHarvestFruits = true;
        this.canHarvestVegetables = true;
        this.harvestSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.sheep.shear"));
    }

    public CookToolItem(String name, int durability, int xpBonus, int minLevel, float harvestSpeed, boolean canHarvestFruits, boolean canHarvestVegetables, SoundEvent harvestSoundEvent) {
        super(name, durability, xpBonus, minLevel, MinePieceJobs.COOK, harvestSpeed, MinePiece.ITEMS);
        this.canHarvestFruits = canHarvestFruits;
        this.canHarvestVegetables = canHarvestVegetables;
        this.harvestSound = harvestSoundEvent;
    }

    public boolean canHarvestFruits() {
        return this.canHarvestFruits;
    }

    public boolean canHarvestVegetables() {
        return this.canHarvestVegetables;
    }

    public SoundEvent getHarvestSound() {
        return this.harvestSound;
    }

    @Override
    public boolean canHarvestBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean isFruitBlock = block.func_149739_a().contains("abricotier") || block.func_149739_a().contains("bananier") || block.func_149739_a().contains("cerise") || block.func_149739_a().contains("citron") || block.func_149739_a().contains("clementine") || block.func_149739_a().contains("olivier") || block.func_149739_a().contains("orange") || block.func_149739_a().contains("pommier");
        boolean isVegetableBlock = block.func_149739_a().contains("aubergine") || block.func_149739_a().contains("basilic") || block.func_149739_a().contains("betterave") || block.func_149739_a().contains("ble") || block.func_149739_a().contains("brocoli") || block.func_149739_a().contains("carotte") || block.func_149739_a().contains("chou") || block.func_149739_a().contains("concombre") || block.func_149739_a().contains("courgette") || block.func_149739_a().contains("fraise") || block.func_149739_a().contains("haricot") || block.func_149739_a().contains("kiwi") || block.func_149739_a().contains("mais") || block.func_149739_a().contains("navet") || block.func_149739_a().contains("oignon") || block.func_149739_a().contains("origan") || block.func_149739_a().contains("patate") || block.func_149739_a().contains("persil") || block.func_149739_a().contains("petit_pois") || block.func_149739_a().contains("piment") || block.func_149739_a().contains("poireau") || block.func_149739_a().contains("poivron") || block.func_149739_a().contains("potiron") || block.func_149739_a().contains("radis") || block.func_149739_a().contains("raisin") || block.func_149739_a().contains("riz") || block.func_149739_a().contains("salade") || block.func_149739_a().contains("soja") || block.func_149739_a().contains("tomate");
        return isFruitBlock && this.canHarvestFruits || isVegetableBlock && this.canHarvestVegetables;
    }

    public boolean applyCookWear(ItemStack stack, EntityPlayer player, int amount) {
        IMinePieceData mpData;
        if (player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null) && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null && mpData.getJob() == MinePieceJobs.COOK) {
            float reduction = Math.min(0.5f, (float)mpData.getJobLevel() * 0.01f);
            amount = Math.max(1, Math.round((float)amount * (1.0f - reduction)));
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77972_a(amount, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult result = super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        if (result == EnumActionResult.SUCCESS && !worldIn.field_72995_K && this.harvestSound != null) {
            worldIn.func_184133_a(null, pos, this.harvestSound, SoundCategory.BLOCKS, 0.8f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        return result;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

