/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs.cook;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModPotions;
import fr.minepiece.common.items.IMetaProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CookFoodItem
extends ItemFood
implements IMetaProvider {
    public static final int NORMAL_META = 0;
    public static final int POISONED_META = 1;
    public static final int NARCOTIC_META = 2;
    public static final String[] VARIANTS = new String[]{"normal", "poisoned", "narcotic"};
    private final int cookLevel;
    private float qualityBonus;
    private final List<PotionEffect> normalEffects;
    private final List<PotionEffect> poisonedEffects;
    private final List<PotionEffect> narcoticEffects;

    public CookFoodItem(String name, int healAmount, float saturation, int cookLevel) {
        super(healAmount, saturation, false);
        this.cookLevel = cookLevel;
        this.qualityBonus = 0.0f;
        this.normalEffects = new ArrayList<PotionEffect>();
        this.poisonedEffects = new ArrayList<PotionEffect>();
        this.narcoticEffects = new ArrayList<PotionEffect>();
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(MinePiece.FOOD);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public CookFoodItem(String name, int healAmount, float saturation, int cookLevel, float qualityBonus) {
        this(name, healAmount, saturation, cookLevel);
        this.qualityBonus = qualityBonus;
    }

    public CookFoodItem addNormalEffect(PotionEffect effect) {
        this.normalEffects.add(effect);
        return this;
    }

    public CookFoodItem addPoisonedEffect(PotionEffect effect) {
        this.poisonedEffects.add(effect);
        return this;
    }

    public CookFoodItem addNarcoticEffect(PotionEffect effect) {
        this.narcoticEffects.add(effect);
        return this;
    }

    public boolean canDetectPoison(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
            IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            return mpData != null && mpData.getJob() == MinePieceJobs.COOK && mpData.getJobLevel() >= this.cookLevel;
        }
        return false;
    }

    public boolean isPoisoned(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    public boolean isNarcotic(ItemStack stack) {
        return stack.func_77960_j() == 2;
    }

    public ItemStack createPoisonedStack(int count) {
        return new ItemStack((Item)this, count, 1);
    }

    public ItemStack createNarcoticStack(int count) {
        return new ItemStack((Item)this, count, 2);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        ItemStack resultStack = super.func_77654_b(stack, world, entityLiving);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!world.field_72995_K) {
                for (PotionEffect effect : this.normalEffects) {
                    player.func_70690_d(new PotionEffect(effect));
                }
                if (this.isPoisoned(stack)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 600, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 300, 0));
                    for (PotionEffect effect : this.poisonedEffects) {
                        player.func_70690_d(new PotionEffect(effect));
                    }
                } else if (this.isNarcotic(stack)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 600, 1));
                    for (PotionEffect effect : this.narcoticEffects) {
                        player.func_70690_d(new PotionEffect(effect));
                    }
                    final EntityPlayer finalPlayer = player;
                    world.func_73046_m().func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (finalPlayer.func_70089_S() && !finalPlayer.field_70170_p.field_72995_K) {
                                    finalPlayer.func_70690_d(new PotionEffect(ModPotions.KNOCKED_OUT_EFFECT, 1200, 0));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }
        return resultStack;
    }

    public int func_150905_g(ItemStack stack) {
        int baseAmount = super.func_150905_g(stack);
        if (this.isPoisoned(stack) || this.isNarcotic(stack)) {
            return Math.max(1, baseAmount / 2);
        }
        return baseAmount;
    }

    public float func_150906_h(ItemStack stack) {
        float baseSaturation = super.func_150906_h(stack);
        if (this.isPoisoned(stack) || this.isNarcotic(stack)) {
            return baseSaturation / 2.0f;
        }
        return baseSaturation;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (flag.func_194127_a()) {
            tooltip.add("\u00a78Meta: " + stack.func_77960_j());
        }
        int restauration = this.func_150905_g(stack);
        tooltip.add("\u00a76Restaure: \u00a7e" + restauration + " gigots");
        int sat = (int)this.func_150906_h(stack);
        tooltip.add("\u00a7aSaturation : \u00a7e" + sat);
        if (world != null && world.field_72995_K) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && (this.isPoisoned(stack) || this.isNarcotic(stack)) && this.canDetectPoison((EntityPlayer)player)) {
                tooltip.add("\u00a74\u26a0 EMPOISONN\u00c9 \u26a0");
            }
            if (this.qualityBonus > 0.0f) {
                tooltip.add("\u00a76Qualit\u00e9: \u00a7e+" + this.qualityBonus);
            }
        }
    }

    @Override
    public String getVariantName(int meta) {
        if (meta < 0 || meta >= VARIANTS.length) {
            meta = 0;
        }
        return VARIANTS[meta];
    }
}

