/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs.cook;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.capability.thirst.ThirstProvider;
import fr.minepiece.common.items.BeverageItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CookBeverageItem
extends BeverageItem {
    private final List<PotionEffect> effects = new ArrayList<PotionEffect>();
    private final List<PotionEffect> delayedEffects = new ArrayList<PotionEffect>();
    private final int delayTime;
    private final int cuisinierLevel;
    private final float reputationBonus;
    private boolean isPremium;
    private final float gigotRestoration;
    private final int maxUses;
    private static final String USES_LEFT_TAG = "UsesLeft";

    public CookBeverageItem(String name, float thirstQuenching, float thirstSaturation, boolean isUnclean, ItemStack returnItem, int cuisinierLevel) {
        this(name, thirstQuenching, thirstSaturation, isUnclean, returnItem, cuisinierLevel, 0.0f, 60, 0.0f, 1);
    }

    public CookBeverageItem(String name, float thirstQuenching, float thirstSaturation, boolean isUnclean, ItemStack returnItem, int cuisinierLevel, float gigotRestoration, int delayTime, float reputationBonus) {
        this(name, thirstQuenching, thirstSaturation, isUnclean, returnItem, cuisinierLevel, gigotRestoration, delayTime, reputationBonus, 1);
    }

    public CookBeverageItem(String name, float thirstQuenching, float thirstSaturation, boolean isUnclean, ItemStack returnItem, int cuisinierLevel, float gigotRestoration, int delayTime, float reputationBonus, int maxUses) {
        super(name, thirstQuenching, thirstSaturation, isUnclean, returnItem);
        this.delayTime = delayTime;
        this.cuisinierLevel = cuisinierLevel;
        this.reputationBonus = reputationBonus;
        this.isPremium = false;
        this.gigotRestoration = gigotRestoration;
        this.maxUses = Math.max(1, maxUses);
        this.func_77637_a(MinePiece.BEVERAGE);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.initializeNBT(stack);
    }

    private void initializeNBT(ItemStack stack) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = stack.func_77978_p()).func_74764_b(USES_LEFT_TAG)) {
            nbt.func_74768_a(USES_LEFT_TAG, this.maxUses);
        }
    }

    public int getUsesLeft(ItemStack stack) {
        if (!stack.func_77942_o()) {
            this.initializeNBT(stack);
        }
        return stack.func_77978_p().func_74762_e(USES_LEFT_TAG);
    }

    public void setUsesLeft(ItemStack stack, int uses) {
        if (!stack.func_77942_o()) {
            this.initializeNBT(stack);
        }
        stack.func_77978_p().func_74768_a(USES_LEFT_TAG, Math.max(0, uses));
    }

    public CookBeverageItem addEffect(PotionEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public CookBeverageItem addDelayedEffect(PotionEffect effect) {
        this.delayedEffects.add(effect);
        return this;
    }

    public CookBeverageItem setPremium(boolean premium) {
        this.isPremium = premium;
        return this;
    }

    public boolean canDetectQuality(EntityPlayer player) {
        if (player != null && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
            IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            return mpData != null && mpData.getJob() == MinePieceJobs.COOK && mpData.getJobLevel() >= this.cuisinierLevel;
        }
        return false;
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!stack.func_77942_o()) {
            this.initializeNBT(stack);
        }
        int usesLeft = this.getUsesLeft(stack);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            IThirst thirst = (IThirst)player.getCapability(ThirstProvider.THIRST_CAPABILITY, null);
            if (thirst != null) {
                thirst.drink(this.getThirstQuenching(stack), this.getThirstSaturation(stack));
                if (this.isUnclean() && world.field_73012_v.nextFloat() < 0.5f) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 600));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 300));
                }
            }
            if (this.gigotRestoration > 0.0f) {
                player.func_71024_bL().func_75122_a(Math.round(this.gigotRestoration * 2.0f), 0.5f);
            }
            if (!world.field_72995_K) {
                for (PotionEffect effect : this.effects) {
                    player.func_70690_d(new PotionEffect(effect));
                }
                if (!this.delayedEffects.isEmpty()) {
                    int tickDelay = this.delayTime * 20;
                    world.func_73046_m().func_152344_a(() -> {
                        if (player.func_70089_S() && !player.field_70128_L) {
                            for (PotionEffect effect : this.delayedEffects) {
                                player.func_70690_d(new PotionEffect(effect));
                            }
                        }
                    });
                }
                if (!(this.reputationBonus > 0.0f) || player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
                    // empty if block
                }
            }
        }
        if (--usesLeft <= 0) {
            return super.func_77654_b(stack, world, entityLiving);
        }
        this.setUsesLeft(stack, usesLeft);
        return stack;
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        EntityPlayerSP player;
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.gigotRestoration > 0.0f) {
            tooltip.add("\u00a76Restaure: \u00a7e" + this.gigotRestoration + " gigots");
        }
        int usesLeft = this.getUsesLeft(stack);
        tooltip.add("\u00a7aGorg\u00e9es restantes: \u00a7e" + usesLeft + "/" + this.maxUses);
        if (world != null && world.field_72995_K && (player = Minecraft.func_71410_x().field_71439_g) != null && this.isPremium && this.canDetectQuality((EntityPlayer)player)) {
            tooltip.add("\u00a7d\u2726 Qualit\u00e9 Premium \u2726");
        }
    }
}

