/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs.blacksmith;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.items.jobs.JobToolItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlacksmithToolItem
extends JobToolItem {
    private final int miningLevel;
    private final float miningSpeed;
    private final boolean isSmithingTool;
    private final boolean canBreakBars;

    public BlacksmithToolItem(String name, int durability, int xpBonus, int minLevel, int miningLevel) {
        super(name, durability, xpBonus, minLevel, MinePieceJobs.BLACKSMITH, 1.0f, MinePiece.ITEMS);
        this.miningLevel = miningLevel;
        this.miningSpeed = 1.0f;
        this.isSmithingTool = false;
        this.canBreakBars = false;
    }

    public BlacksmithToolItem(String name, int durability, int xpBonus, int minLevel, int maxLevel, float harvestSpeed, int miningLevel, float miningSpeed, boolean isSmithingTool, boolean canBreakBars) {
        super(name, durability, xpBonus, minLevel, MinePieceJobs.BLACKSMITH, harvestSpeed, MinePiece.ITEMS);
        this.miningLevel = miningLevel;
        this.miningSpeed = miningSpeed;
        this.isSmithingTool = isSmithingTool;
        this.canBreakBars = canBreakBars;
    }

    public boolean isSmithingTool() {
        return this.isSmithingTool;
    }

    public int getMiningLevel() {
        return this.miningLevel;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public boolean canBreakBars() {
        return this.canBreakBars;
    }

    @Override
    public boolean canHarvestBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (this.canBreakBars && block == Blocks.field_150411_aY) {
            return true;
        }
        if (block == Blocks.field_150366_p || block == Blocks.field_150352_o || block == Blocks.field_150482_ag || block == Blocks.field_150412_bA || block == Blocks.field_150450_ax || block == Blocks.field_150369_x) {
            int blockLevel = 1;
            if (block == Blocks.field_150366_p) {
                blockLevel = 2;
            } else if (block == Blocks.field_150352_o || block == Blocks.field_150482_ag || block == Blocks.field_150412_bA || block == Blocks.field_150450_ax || block == Blocks.field_150369_x) {
                blockLevel = 3;
            } else if (block == Blocks.field_150343_Z) {
                blockLevel = 4;
            }
            return this.miningLevel >= blockLevel;
        }
        return block.func_149739_a().contains("minerai_") || block.func_149739_a().contains("ore_") || block.func_149739_a().contains("granite_marin") || block.func_149739_a().contains("cristal_blanc");
    }

    public boolean applyBlacksmithWear(ItemStack stack, EntityPlayer player, int amount) {
        IMinePieceData mpData;
        if (player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null) && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null && mpData.getJob() == MinePieceJobs.BLACKSMITH) {
            float reduction = Math.min(0.5f, (float)mpData.getJobLevel() * 0.01f);
            amount = Math.max(1, Math.round((float)amount * (1.0f - reduction)));
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77972_a(amount, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult result = super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        if (this.isSmithingTool && result == EnumActionResult.SUCCESS && !worldIn.field_72995_K) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.canBreakBars && worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150411_aY && this.canPlayerUse(player)) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175655_b(pos, true);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187769_eM, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.2f + 0.8f);
                ItemStack heldItem = player.func_184586_b(hand);
                this.applyBlacksmithWear(heldItem, player, 3);
            }
            return EnumActionResult.SUCCESS;
        }
        return result;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150366_p || block == Blocks.field_150352_o || block == Blocks.field_150482_ag || block == Blocks.field_150412_bA || block == Blocks.field_150450_ax || block == Blocks.field_150369_x || block.func_149739_a().contains("minerai_") || block.func_149739_a().contains("ore_")) {
            return this.miningSpeed;
        }
        return super.func_150893_a(stack, state);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

