/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.jobs;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.items.BaseItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class JobToolItem
extends BaseItem {
    private final int durability;
    private final int xpBonus;
    private final int minLevel;
    private final MinePieceJobs requiredJob;
    private final float harvestSpeed;

    public JobToolItem(String name, int durability, int xpBonus, int minLevel, MinePieceJobs requiredJob, float harvestSpeed, CreativeTabs tab) {
        super(name, tab);
        this.durability = durability;
        this.xpBonus = xpBonus;
        this.minLevel = minLevel;
        this.requiredJob = requiredJob;
        this.harvestSpeed = harvestSpeed;
        this.func_77625_d(1);
        this.func_77656_e(durability);
    }

    public int getXpBonus() {
        return this.xpBonus;
    }

    public boolean isUsableAtLevel(int level) {
        return level >= this.minLevel;
    }

    public boolean canPlayerUse(EntityPlayer player) {
        IMinePieceData mpData;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null) && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null) {
            if (this.requiredJob != null && mpData.getJob() != this.requiredJob) {
                return false;
            }
            return this.isUsableAtLevel(mpData.getJobLevel());
        }
        return false;
    }

    public MinePieceJobs getRequiredJob() {
        return this.requiredJob;
    }

    public float getHarvestSpeed() {
        return this.harvestSpeed;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.canPlayerUse(player)) {
            IMinePieceData mpData;
            if (!worldIn.field_72995_K && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null) && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null) {
                if (this.requiredJob != null && mpData.getJob() != this.requiredJob) {
                    player.func_145747_a(new TextComponentTranslation("message.job_tool.wrong_job", new Object[]{this.requiredJob.getName()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                } else if (!this.isUsableAtLevel(mpData.getJobLevel())) {
                    player.func_145747_a(new TextComponentTranslation("message.job_tool.level_required", new Object[]{this.minLevel}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.requiredJob != null) {
            tooltip.add(TextFormatting.AQUA + "M\u00e9tier: " + TextFormatting.WHITE + this.requiredJob.getName());
        }
        tooltip.add(TextFormatting.YELLOW + "Niveau requis: " + TextFormatting.WHITE + this.minLevel);
        if (this.xpBonus > 0) {
            tooltip.add(TextFormatting.GREEN + "Bonus d'XP: +" + TextFormatting.WHITE + this.xpBonus);
        }
        if (this.harvestSpeed != 1.0f) {
            String speedText = this.harvestSpeed > 1.0f ? "Rapide" : "Lent";
            tooltip.add(TextFormatting.GOLD + "Vitesse: " + TextFormatting.WHITE + speedText);
        }
    }

    public abstract boolean canHarvestBlock(World var1, BlockPos var2);
}

