/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.crops;

import fr.minepiece.MinePiece;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SeedItem
extends Item
implements IPlantable {
    private final Block cropBlock;
    private final EnumPlantType plantType;
    private final Item harvestItem;

    public SeedItem(String name, Block cropBlock, Item harvestItem) {
        this(name, cropBlock, harvestItem, EnumPlantType.Crop);
    }

    public SeedItem(String name, Block cropBlock, Item harvestItem, EnumPlantType plantType) {
        this.cropBlock = cropBlock;
        this.harvestItem = harvestItem;
        this.plantType = plantType;
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(MinePiece.CROPS);
        this.func_77625_d(64);
    }

    public Item getHarvestItem() {
        return this.harvestItem;
    }

    public Block getCropBlock() {
        return this.cropBlock;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, stack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), this.cropBlock.func_176223_P());
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.plantType;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.cropBlock.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add("\u00a72Graine \u00e0 planter");
    }
}

