/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items.armors;

import com.google.common.collect.Multimap;
import fr.minepiece.MinePiece;
import fr.minepiece.common.init.ModArmorMaterials;
import fr.minepiece.common.items.INBTProvider;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TieredItemArmor
extends ItemArmor
implements INBTProvider {
    private final String armorType;
    private final int maxTier;
    private final int[] tierDurabilities;
    private final Item upgradeItem;

    public TieredItemArmor(String name, ItemArmor.ArmorMaterial defaultMaterial, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, String armorType, int maxTier, int[] tierDurabilities, Item upgradeItem) {
        super(defaultMaterial, renderIndexIn, equipmentSlotIn);
        ((Item)this.setRegistryName(name)).func_77655_b(name);
        this.func_77637_a(MinePiece.ARMORS);
        this.armorType = armorType;
        this.maxTier = maxTier;
        this.tierDurabilities = tierDurabilities;
        this.upgradeItem = upgradeItem;
        this.func_77656_e(tierDurabilities[0]);
    }

    public int getTier(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Tier")) {
            return stack.func_77978_p().func_74762_e("Tier");
        }
        return 0;
    }

    public int getDisplayTier(ItemStack stack) {
        return this.getTier(stack) + 1;
    }

    public void setTier(ItemStack stack, int tier) {
        if (tier < 0 || tier >= this.maxTier) {
            tier = 0;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Tier", tier);
        this.updateArmorProperties(stack);
    }

    private void updateArmorProperties(ItemStack stack) {
    }

    public int getMaxDamage(ItemStack stack) {
        int tier = this.getTier(stack);
        return this.tierDurabilities[tier];
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int tier = this.getTier(stack) + 1;
        String slotName = slot == EntityEquipmentSlot.LEGS ? "2" : "1";
        return "minepiece:textures/model/armor/" + this.armorType + "_tier" + tier + "_layer_" + slotName + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.maxTier; ++i) {
                ItemStack stack = new ItemStack((Item)this);
                this.setTier(stack, i);
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        TextFormatting color;
        int tier = this.getTier(stack);
        int displayTier = this.getDisplayTier(stack);
        ItemArmor.ArmorMaterial currentMaterial = ModArmorMaterials.getMaterialForTierAndType(tier, this.armorType);
        int armorValue = currentMaterial.func_78044_b(this.func_185083_B_());
        switch (displayTier) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.AQUA;
                break;
            }
            case 3: {
                color = TextFormatting.GREEN;
                break;
            }
            default: {
                color = TextFormatting.WHITE;
            }
        }
        tooltip.add(color + "Tier " + displayTier);
        tooltip.add(TextFormatting.GRAY + "Durabilit\u00e9: " + this.getMaxDamage(stack));
        tooltip.add(TextFormatting.BLUE + "Protection: " + armorValue);
    }

    public ItemArmor.ArmorMaterial getMaterialForTier(ItemStack stack) {
        int tier = this.getTier(stack);
        return ModArmorMaterials.getMaterialForTierAndType(tier, this.armorType);
    }

    public float getToughness(ItemStack stack) {
        return this.getMaterialForTier(stack).func_189416_e();
    }

    public void handleArmorBreak(ItemStack stack, EntityPlayer player) {
        ItemStack fragmentStack;
        int tier = this.getTier(stack);
        if (tier > 0 && !player.field_71071_by.func_70441_a(fragmentStack = new ItemStack(this.upgradeItem, 1, tier - 1))) {
            player.func_71019_a(fragmentStack, false);
        }
    }

    public boolean canUpgrade(ItemStack stack) {
        int tier = this.getTier(stack);
        return tier < this.maxTier - 1;
    }

    public boolean upgrade(ItemStack stack) {
        if (!this.canUpgrade(stack)) {
            return false;
        }
        int currentTier = this.getTier(stack);
        this.setTier(stack, currentTier + 1);
        return true;
    }

    @Override
    public String getVariantName(NBTTagCompound nbt) {
        int tier = nbt.func_74764_b("Tier") ? nbt.func_74762_e("Tier") : 0;
        return "tier_" + (tier + 1);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        ItemArmor.ArmorMaterial material = this.getMaterialForTier(stack);
        multimap.removeAll((Object)SharedMonsterAttributes.field_188791_g.func_111108_a());
        multimap.removeAll((Object)SharedMonsterAttributes.field_189429_h.func_111108_a());
        UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
        multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", (double)material.func_78044_b(slot), 0));
        multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", (double)material.func_189416_e(), 0));
        return multimap;
    }
}

