/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.items;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.capability.thirst.ThirstProvider;
import fr.minepiece.common.items.BaseItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FoodItem
extends BaseItem
implements IPlantable {
    private final float healAmount;
    private final float thirstAmount;
    private final float thirstSaturation;
    private final int useTime;
    private final List<PotionEffect> effects;
    private boolean isAlwaysEdible;
    private ItemStack returnContainer;
    private boolean hasAnyPoisonEffect;
    private boolean isPlantable;
    private IBlockState plantState;
    private EnumPlantType plantType;

    public FoodItem(String name, float healAmount, float thirstAmount, int useTime) {
        this(name, healAmount, thirstAmount, 0.0f, useTime, MinePiece.FOOD);
    }

    public FoodItem(String name, float healAmount, float thirstAmount, float thirstSaturation, int useTime, CreativeTabs tab) {
        super(name, tab);
        this.healAmount = healAmount;
        this.thirstAmount = thirstAmount;
        this.thirstSaturation = thirstSaturation;
        this.useTime = useTime;
        this.effects = new ArrayList<PotionEffect>();
        this.isAlwaysEdible = false;
        this.returnContainer = ItemStack.field_190927_a;
        this.hasAnyPoisonEffect = false;
        this.isPlantable = false;
        this.plantState = null;
        this.plantType = EnumPlantType.Crop;
        this.func_77637_a(MinePiece.FOOD);
        this.func_77625_d(16);
    }

    public FoodItem setPlantable(IBlockState plantState, EnumPlantType plantType) {
        this.isPlantable = true;
        this.plantState = plantState;
        this.plantType = plantType;
        return this;
    }

    public FoodItem setPlantable(IBlockState plantState) {
        return this.setPlantable(plantState, EnumPlantType.Crop);
    }

    public boolean isPlantable() {
        return this.isPlantable && this.plantState != null;
    }

    public FoodItem addEffect(PotionEffect effect, float probability) {
        if (probability >= 1.0f || Math.random() < (double)probability) {
            this.effects.add(effect);
            if (effect.func_188419_a().func_76398_f()) {
                this.hasAnyPoisonEffect = true;
            }
        }
        return this;
    }

    public FoodItem setAlwaysEdible(boolean isAlwaysEdible) {
        this.isAlwaysEdible = isAlwaysEdible;
        return this;
    }

    public FoodItem setReturnContainer(ItemStack container) {
        this.returnContainer = container;
        return this;
    }

    public boolean isPoisonous() {
        return this.hasAnyPoisonEffect;
    }

    public boolean canDetectPoison(EntityPlayer player, ItemStack stack) {
        if (player != null && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
            IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            return mpData != null && mpData.getJob() == MinePieceJobs.COOK && mpData.getJobLevel() >= 15;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return this.useTime * 20;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_71043_e(this.isAlwaysEdible)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            IThirst thirst;
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (this.healAmount > 0.0f) {
                player.func_71024_bL().func_75122_a(Math.round(this.healAmount), 0.5f);
            }
            if (this.thirstAmount > 0.0f && player.hasCapability(ThirstProvider.THIRST_CAPABILITY, null) && (thirst = (IThirst)player.getCapability(ThirstProvider.THIRST_CAPABILITY, null)) != null) {
                thirst.drink(this.thirstAmount, this.thirstSaturation);
            }
            if (!world.field_72995_K) {
                for (PotionEffect effect : this.effects) {
                    player.func_70690_d(new PotionEffect(effect));
                }
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_190926_b() && !this.returnContainer.func_190926_b()) {
                return this.returnContainer.func_77946_l();
            }
        }
        return stack;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.isPlantable()) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, stack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), this.plantState);
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.plantType;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.plantState;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        EntityPlayerSP player;
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add("\u00a76Restaure: \u00a7e" + this.healAmount / 2.0f + " gigots");
        if (this.thirstAmount > 0.0f) {
            tooltip.add("\u00a79Hydratation: \u00a7b+" + this.thirstAmount);
        }
        if (this.isPlantable()) {
            tooltip.add("\u00a72Peut \u00eatre plant\u00e9");
        }
        EntityPlayerSP entityPlayerSP = player = world != null && world.field_72995_K ? Minecraft.func_71410_x().field_71439_g : null;
        if (player != null && this.isPoisonous() && this.canDetectPoison((EntityPlayer)player, stack)) {
            tooltip.add("\u00a7c\u26a0 Cet aliment contient du poison! \u00a7c\u26a0");
        }
    }
}

