/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.init;

import fr.minepiece.MinePiece;
import fr.minepiece.common.items.BaseItem;
import fr.minepiece.common.items.weapons.ItemDynamite;
import fr.minepiece.common.items.weapons.SmokeBombItem;
import fr.minepiece.common.items.weapons.shooting.AceItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="minepiece")
public class ModWeapons {
    public static final Item ACE = new AceItem("ace", Item.ToolMaterial.DIAMOND, 10.0f, 1);
    public static final Item DYNAMITE = new ItemDynamite();
    public static final Item SMOKE_BOMB = new SmokeBombItem();
    public static final Item BULLET = new BaseItem("bullet").func_77637_a(MinePiece.WEAPONS).func_77625_d(32);
    public static final Item BAZOOKA_SHELL = new BaseItem("bazooka_shell").func_77637_a(MinePiece.WEAPONS).func_77625_d(16);

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ACE);
        registry.register((IForgeRegistryEntry)DYNAMITE);
        registry.register((IForgeRegistryEntry)SMOKE_BOMB);
        registry.register((IForgeRegistryEntry)BULLET);
        registry.register((IForgeRegistryEntry)BAZOOKA_SHELL);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerRenders(ModelRegistryEvent event) {
        ModWeapons.registerRender(ACE);
        for (int meta = 0; meta < ItemDynamite.VARIANTS.length; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)DYNAMITE, (int)meta, (ModelResourceLocation)new ModelResourceLocation(DYNAMITE.getRegistryName() + "_" + ItemDynamite.VARIANTS[meta], "inventory"));
        }
        ModWeapons.registerRender(SMOKE_BOMB);
        ModWeapons.registerRender(BULLET);
        ModWeapons.registerRender(BAZOOKA_SHELL);
    }

    private static void registerRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("minepiece", item.func_77658_a().substring(5)), "inventory"));
    }
}

