/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.init;

import net.minecraft.item.Item;
import net.minecraftforge.common.util.EnumHelper;

public class ModWeaponMaterials {
    public static final Item.ToolMaterial TIER_1 = EnumHelper.addToolMaterial((String)"tier_1", (int)0, (int)1000, (float)1.0f, (float)3.0f, (int)10);
    public static final Item.ToolMaterial TIER_2 = EnumHelper.addToolMaterial((String)"tier_2", (int)0, (int)2000, (float)1.0f, (float)4.0f, (int)12);
    public static final Item.ToolMaterial TIER_3 = EnumHelper.addToolMaterial((String)"tier_3", (int)0, (int)3000, (float)1.0f, (float)5.0f, (int)15);
    public static final Item.ToolMaterial TIER_4 = EnumHelper.addToolMaterial((String)"tier_4", (int)0, (int)4000, (float)1.0f, (float)6.0f, (int)18);
    public static final Item.ToolMaterial TIER_5 = EnumHelper.addToolMaterial((String)"tier_5", (int)0, (int)5000, (float)1.0f, (float)8.0f, (int)22);
    public static final int WEAPON_TYPE_SWORD = 0;
    public static final int WEAPON_TYPE_KATANA = 1;
    public static final int WEAPON_TYPE_LONGSWORD = 2;
    public static final int WEAPON_TYPE_BATTLEAXE = 3;
    public static final int WEAPON_TYPE_MACE = 4;
    public static final int WEAPON_TYPE_LANCE = 5;
    public static final int WEAPON_TYPE_TRIDENT = 6;
    public static final int WEAPON_TYPE_DAGGER = 7;
    public static final float LANCE_REACH = 0.4f;
    public static final float DAGGER_REACH = -0.3f;
    public static final float DEFAULT_REACH = 0.0f;
    public static final int MACE_KNOCKBACK_LEVEL = 2;
    public static final float TRIDENT_WATER_DAMAGE_BONUS = 2.0f;
    private static final int[] TIER_DURABILITIES = new int[]{1000, 2000, 3000, 4000, 5000};
    private static final float[][] WEAPON_DAMAGE_VALUES = new float[][]{{4.0f, 4.0f, 5.0f, 6.0f, 8.0f}, {3.0f, 5.0f, 6.0f, 7.0f, 7.0f}, {6.0f, 7.0f, 8.0f, 8.0f, 10.0f}, {6.0f, 6.0f, 7.0f, 8.0f, 12.0f}, {5.0f, 6.0f, 6.0f, 7.0f, 9.0f}, {3.0f, 4.0f, 4.0f, 5.0f, 6.0f}, {5.0f, 6.0f, 6.0f, 7.0f, 8.0f}, {3.0f, 4.0f, 5.0f, 6.0f, 6.5f}};
    private static final float[][] WEAPON_SPEED_VALUES = new float[][]{{-0.2f, -0.1f, -0.1f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.1f, 0.1f, 0.2f}, {-0.4f, -0.4f, -0.4f, -0.2f, -0.2f}, {-0.8f, -0.8f, -0.8f, -0.7f, -0.6f}, {-0.8f, -0.8f, -0.7f, -0.6f, -0.6f}, {-0.1f, -0.1f, 0.0f, 0.0f, 0.1f}, {-0.1f, -0.1f, 0.0f, 0.0f, 0.1f}, {0.4f, 0.4f, 0.5f, 0.6f, 0.7f}};

    public static int getDurabilityForTier(int tier) {
        if (tier < 0 || tier >= TIER_DURABILITIES.length) {
            tier = 0;
        }
        return TIER_DURABILITIES[tier];
    }

    public static int[] getAllDurabilities() {
        return TIER_DURABILITIES;
    }

    public static float[] getDamageValuesForWeaponType(int weaponType) {
        if (weaponType < 0 || weaponType >= WEAPON_DAMAGE_VALUES.length) {
            weaponType = 0;
        }
        return WEAPON_DAMAGE_VALUES[weaponType];
    }

    public static float[] getSpeedValuesForWeaponType(int weaponType) {
        if (weaponType < 0 || weaponType >= WEAPON_SPEED_VALUES.length) {
            weaponType = 0;
        }
        return WEAPON_SPEED_VALUES[weaponType];
    }

    public static boolean isLance(int weaponType) {
        return weaponType == 5;
    }

    public static boolean isDagger(int weaponType) {
        return weaponType == 7;
    }

    public static boolean isMace(int weaponType) {
        return weaponType == 4;
    }

    public static boolean isTrident(int weaponType) {
        return weaponType == 6;
    }

    public static float getReachForWeaponType(int weaponType) {
        if (ModWeaponMaterials.isLance(weaponType)) {
            return 0.4f;
        }
        if (ModWeaponMaterials.isDagger(weaponType)) {
            return -0.3f;
        }
        return 0.0f;
    }

    public static int getKnockbackLevelForWeaponType(int weaponType) {
        if (ModWeaponMaterials.isMace(weaponType)) {
            return 2;
        }
        return 0;
    }

    public static float calculateBonusDamage(int weaponType, boolean isPlayerInWater) {
        if (ModWeaponMaterials.isTrident(weaponType) && isPlayerInWater) {
            return 2.0f;
        }
        return 0.0f;
    }
}

