/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.init;

import fr.minepiece.common.init.ModArmorMaterials;
import fr.minepiece.common.init.ModWeaponMaterials;
import fr.minepiece.common.items.IMetaProvider;
import fr.minepiece.common.items.INBTProvider;
import fr.minepiece.common.items.armors.ArmorFragmentItem;
import fr.minepiece.common.items.armors.TieredItemArmor;
import fr.minepiece.common.items.weapons.TieredItemSword;
import fr.minepiece.common.items.weapons.WeaponFragmentItem;
import fr.minepiece.common.items.weapons.shooting.TieredBazooka;
import fr.minepiece.common.items.weapons.shooting.TieredFlintlockPistol;
import fr.minepiece.common.items.weapons.shooting.TieredFlintlockRifle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="minepiece")
public class ModTieredItems {
    public static final Item WEAPON_FRAGMENT = new WeaponFragmentItem();
    public static final Item ARMOR_FRAGMENT = new ArmorFragmentItem();
    public static final Item TIERED_SWORD = new TieredItemSword("tiered_sword", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(0), ModWeaponMaterials.getSpeedValuesForWeaponType(0), WEAPON_FRAGMENT);
    public static final Item TIERED_KATANA = new TieredItemSword("tiered_katana", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(1), ModWeaponMaterials.getSpeedValuesForWeaponType(1), WEAPON_FRAGMENT);
    public static final Item TIERED_LONGSWORD = new TieredItemSword("tiered_longsword", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(2), ModWeaponMaterials.getSpeedValuesForWeaponType(2), WEAPON_FRAGMENT);
    public static final Item TIERED_BATTLEAXE = new TieredItemSword("tiered_battleaxe", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(3), ModWeaponMaterials.getSpeedValuesForWeaponType(3), WEAPON_FRAGMENT);
    public static final Item TIERED_MACE = new TieredItemSword("tiered_mace", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(4), ModWeaponMaterials.getSpeedValuesForWeaponType(4), WEAPON_FRAGMENT);
    public static final Item TIERED_LANCE = new TieredItemSword("tiered_lance", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(5), ModWeaponMaterials.getSpeedValuesForWeaponType(5), WEAPON_FRAGMENT);
    public static final Item TIERED_TRIDENT = new TieredItemSword("tiered_trident", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(6), ModWeaponMaterials.getSpeedValuesForWeaponType(6), WEAPON_FRAGMENT);
    public static final Item TIERED_DAGGER = new TieredItemSword("tiered_dagger", ModWeaponMaterials.TIER_1, 5, ModWeaponMaterials.getAllDurabilities(), ModWeaponMaterials.getDamageValuesForWeaponType(7), ModWeaponMaterials.getSpeedValuesForWeaponType(7), WEAPON_FRAGMENT);
    public static final Item TIERED_FLINTLOCK_PISTOL = new TieredFlintlockPistol("tiered_flintlock_pistol", ModWeaponMaterials.TIER_1, WEAPON_FRAGMENT);
    public static final Item TIERED_FLINTLOCK_RIFLE = new TieredFlintlockRifle("tiered_flintlock_rifle", ModWeaponMaterials.TIER_1, WEAPON_FRAGMENT);
    public static final Item TIERED_BAZOOKA = new TieredBazooka("tiered_bazooka", ModWeaponMaterials.TIER_1, WEAPON_FRAGMENT);
    public static final Item TIERED_HELMET = new TieredItemArmor("tiered_base_helmet", ModArmorMaterials.BASE_TIER_1, 1, EntityEquipmentSlot.HEAD, "base", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);
    public static final Item TIERED_MARINE_HELMET = new TieredItemArmor("tiered_marine_helmet", ModArmorMaterials.MARINE_TIER_1, 1, EntityEquipmentSlot.HEAD, "marine", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);
    public static final Item TIERED_CHESTPLATE = new TieredItemArmor("tiered_base_chestplate", ModArmorMaterials.BASE_TIER_1, 1, EntityEquipmentSlot.CHEST, "base", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);
    public static final Item TIERED_MARINE_CHESTPLATE = new TieredItemArmor("tiered_marine_chestplate", ModArmorMaterials.MARINE_TIER_1, 1, EntityEquipmentSlot.CHEST, "marine", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);
    public static final Item TIERED_LEGGINGS = new TieredItemArmor("tiered_base_leggings", ModArmorMaterials.BASE_TIER_1, 2, EntityEquipmentSlot.LEGS, "base", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);
    public static final Item TIERED_MARINE_LEGGINGS = new TieredItemArmor("tiered_marine_leggings", ModArmorMaterials.MARINE_TIER_1, 2, EntityEquipmentSlot.LEGS, "marine", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);
    public static final Item TIERED_BOOTS = new TieredItemArmor("tiered_base_boots", ModArmorMaterials.BASE_TIER_1, 1, EntityEquipmentSlot.FEET, "base", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);
    public static final Item TIERED_MARINE_BOOTS = new TieredItemArmor("tiered_marine_boots", ModArmorMaterials.MARINE_TIER_1, 1, EntityEquipmentSlot.FEET, "marine", 3, new int[]{1000, 1500, 2000}, ARMOR_FRAGMENT);

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register((IForgeRegistryEntry)WEAPON_FRAGMENT);
        registry.register((IForgeRegistryEntry)ARMOR_FRAGMENT);
        registry.register((IForgeRegistryEntry)TIERED_SWORD);
        registry.register((IForgeRegistryEntry)TIERED_KATANA);
        registry.register((IForgeRegistryEntry)TIERED_LONGSWORD);
        registry.register((IForgeRegistryEntry)TIERED_BATTLEAXE);
        registry.register((IForgeRegistryEntry)TIERED_MACE);
        registry.register((IForgeRegistryEntry)TIERED_LANCE);
        registry.register((IForgeRegistryEntry)TIERED_TRIDENT);
        registry.register((IForgeRegistryEntry)TIERED_DAGGER);
        registry.register((IForgeRegistryEntry)TIERED_FLINTLOCK_PISTOL);
        registry.register((IForgeRegistryEntry)TIERED_FLINTLOCK_RIFLE);
        registry.register((IForgeRegistryEntry)TIERED_BAZOOKA);
        registry.register((IForgeRegistryEntry)TIERED_HELMET);
        registry.register((IForgeRegistryEntry)TIERED_MARINE_HELMET);
        registry.register((IForgeRegistryEntry)TIERED_CHESTPLATE);
        registry.register((IForgeRegistryEntry)TIERED_MARINE_CHESTPLATE);
        registry.register((IForgeRegistryEntry)TIERED_LEGGINGS);
        registry.register((IForgeRegistryEntry)TIERED_MARINE_LEGGINGS);
        registry.register((IForgeRegistryEntry)TIERED_BOOTS);
        registry.register((IForgeRegistryEntry)TIERED_MARINE_BOOTS);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerRenders(ModelRegistryEvent e) {
        NBTTagCompound compound;
        int i;
        for (i = 0; i < 5; ++i) {
            ModTieredItems.renderWithMeta(WEAPON_FRAGMENT, i);
        }
        for (i = 0; i < 3; ++i) {
            ModTieredItems.renderWithMeta(ARMOR_FRAGMENT, i);
        }
        for (i = 0; i < 5; ++i) {
            compound = new NBTTagCompound();
            compound.func_74768_a("Tier", i);
            ModTieredItems.renderWithNBT(TIERED_SWORD, compound);
            ModTieredItems.renderWithNBT(TIERED_KATANA, compound);
            ModTieredItems.renderWithNBT(TIERED_LONGSWORD, compound);
            ModTieredItems.renderWithNBT(TIERED_BATTLEAXE, compound);
            ModTieredItems.renderWithNBT(TIERED_MACE, compound);
            ModTieredItems.renderWithNBT(TIERED_LANCE, compound);
            ModTieredItems.renderWithNBT(TIERED_TRIDENT, compound);
            ModTieredItems.renderWithNBT(TIERED_DAGGER, compound);
        }
        for (i = 0; i < 3; ++i) {
            compound = new NBTTagCompound();
            compound.func_74768_a("Tier", i);
            ModTieredItems.renderWithNBT(TIERED_FLINTLOCK_PISTOL, compound);
            ModTieredItems.renderWithNBT(TIERED_FLINTLOCK_RIFLE, compound);
            ModTieredItems.renderWithNBT(TIERED_BAZOOKA, compound);
        }
        for (i = 0; i < 3; ++i) {
            compound = new NBTTagCompound();
            compound.func_74768_a("Tier", i);
            ModTieredItems.renderWithNBT(TIERED_HELMET, compound);
            ModTieredItems.renderWithNBT(TIERED_MARINE_HELMET, compound);
            ModTieredItems.renderWithNBT(TIERED_CHESTPLATE, compound);
            ModTieredItems.renderWithNBT(TIERED_MARINE_CHESTPLATE, compound);
            ModTieredItems.renderWithNBT(TIERED_LEGGINGS, compound);
            ModTieredItems.renderWithNBT(TIERED_MARINE_LEGGINGS, compound);
            ModTieredItems.renderWithNBT(TIERED_BOOTS, compound);
            ModTieredItems.renderWithNBT(TIERED_MARINE_BOOTS, compound);
        }
    }

    private static void renderWithNBT(Item item, NBTTagCompound nbt) {
        INBTProvider provider = (INBTProvider)item;
        String path = item.func_77658_a().substring(5);
        String variantPath = path + "_" + provider.getVariantName(nbt);
        System.out.println("Registering model path: " + variantPath);
        if (item instanceof TieredItemSword) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("minepiece", path), "inventory"));
        }
    }

    private static void renderWithMeta(Item item, int meta) {
        IMetaProvider provider = (IMetaProvider)item;
        String path = item.func_77658_a().substring(5);
        String variantPath = path + "_" + provider.getVariantName(meta);
        System.out.println("Registering model path: " + variantPath);
        if (item instanceof TieredItemSword) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("minepiece", path), "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("minepiece", variantPath), "inventory"));
        }
    }
}

