/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.init;

import fr.minepiece.common.init.MinePieceLoadingPlugin;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import org.apache.logging.log4j.Level;

public class MinePieceDuplicateChecker
implements IFMLCallHook {
    public Void call() throws Exception {
        this.logDebug("Searching for duplicate SkyblockAddons installations...");
        try {
            List<Object> coremodList = MinePieceLoadingPlugin.coremodList;
            Field nameField = coremodList.get(0).getClass().getField("name");
            boolean coreFound = false;
            nameField.setAccessible(true);
            for (Object coreMod : coremodList) {
                String name = (String)nameField.get(coreMod);
                if (!name.equals(MinePieceLoadingPlugin.class.getSimpleName())) continue;
                if (!coreFound) {
                    coreFound = true;
                    continue;
                }
                throw new RuntimeException("Launch failed because a duplicate installation of MinePiece was found. Please remove it and restart Minecraft!");
            }
            nameField.setAccessible(false);
            this.logDebug("No duplicate installations were found");
        }
        catch (ReflectiveOperationException ex) {
            this.log(Level.ERROR, ex, "An error occurred while checking for duplicate MinePiece installations!");
        }
        return null;
    }

    private void logDebug(String message) {
        this.log(Level.DEBUG, null, message);
    }

    private void log(Level level, Throwable throwable, String message) {
        String loggerName = "MinePiece/" + this.getClass().getSimpleName();
        FMLRelaunchLog.log((String)loggerName, (Level)level, (String)("[" + loggerName + "] " + message), (Object[])new Object[0]);
    }

    public void injectData(Map<String, Object> data) {
    }
}

