/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.handlers;

import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.items.weapons.IReachWeapon;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="minepiece")
public class ReachHandler {
    public static final double BASE_SURVIVAL_REACH = 3.0;
    public static final double BASE_CREATIVE_REACH = 6.0;
    private static final double CREATIVE_REACH = 5.0;
    private static final double GIANT_REACH = 4.75;
    private static final double TONTATTA_REACH = 2.5;
    private static final double DEFAULT_SURVIVAL_REACH = 3.0;
    private static final double MINIMUM_REACH = 1.0;

    public static double getEffectiveReach(EntityPlayer player, ItemStack stack) {
        double baseReach;
        if (player.func_184812_l_()) {
            baseReach = 5.0;
        } else {
            baseReach = 3.0;
            IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            if (data != null) {
                int raceId = data.getRaceID();
                if (raceId == 4) {
                    baseReach = 4.75;
                } else if (raceId == 5) {
                    baseReach = 2.5;
                }
            }
        }
        float itemModifier = 0.0f;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IReachWeapon) {
            IReachWeapon reachWeapon = (IReachWeapon)stack.func_77973_b();
            itemModifier = (float)reachWeapon.getReach(stack, player);
        }
        double finalReach = baseReach + (double)itemModifier;
        return Math.max(1.0, finalReach);
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (target == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack heldStack = player.func_184614_ca();
        double effectiveReach = ReachHandler.getEffectiveReach(player, heldStack);
        double reachSq = effectiveReach * effectiveReach;
        double distanceSq = player.func_70068_e(target);
        double tolerance = 0.1;
        double distanceWithToleranceSq = player.func_174791_d().func_72436_e(target.func_174791_d().func_178787_e(target.func_70040_Z()));
        if (distanceSq > reachSq + tolerance) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        if (event.getButton() == 0 && event.isButtonstate()) {
            RayTraceResult customMouseOver;
            double vanillaReach;
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player == null || mc.field_71441_e == null || mc.field_71442_b == null) {
                return;
            }
            ItemStack heldStack = player.func_184614_ca();
            double effectiveReach = ReachHandler.getEffectiveReach((EntityPlayer)player, heldStack);
            double d = vanillaReach = mc.field_71442_b.func_78758_h() ? 5.0 : 3.0;
            if (effectiveReach > vanillaReach && (customMouseOver = ReachHandler.rayTraceEntity((EntityPlayer)player, effectiveReach)) != null && customMouseOver.field_72313_a == RayTraceResult.Type.ENTITY && customMouseOver.field_72308_g != null) {
                boolean vanillaMissedOrDifferent;
                Entity targetEntity = customMouseOver.field_72308_g;
                boolean bl = vanillaMissedOrDifferent = mc.field_71476_x == null || mc.field_71476_x.field_72313_a != RayTraceResult.Type.ENTITY || mc.field_71476_x.field_72308_g != targetEntity;
                if (vanillaMissedOrDifferent) {
                    mc.field_71442_b.func_78764_a((EntityPlayer)player, targetEntity);
                    player.func_184609_a(EnumHand.MAIN_HAND);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static RayTraceResult rayTraceEntity(EntityPlayer player, double reach) {
        Entity pointedEntity = null;
        RayTraceResult resultRayTrace = null;
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d eyePosition = player.func_174824_e(1.0f);
        Vec3d lookVector = player.func_70676_i(1.0f);
        Vec3d reachVector = eyePosition.func_178787_e(new Vec3d(lookVector.field_72450_a * reach, lookVector.field_72448_b * reach, lookVector.field_72449_c * reach));
        double closestEntityDistSq = reach * reach;
        float boxExpand = 1.0f;
        AxisAlignedBB searchBox = player.func_174813_aQ().func_72321_a(lookVector.field_72450_a * reach, lookVector.field_72448_b * reach, lookVector.field_72449_c * reach).func_72314_b((double)boxExpand, (double)boxExpand, (double)boxExpand);
        EntityPlayer viewEntity = mc.func_175606_aa() == null ? player : mc.func_175606_aa();
        List potentialTargets = mc.field_71441_e.func_175674_a((Entity)viewEntity, searchBox, entity -> entity != null && entity.func_70067_L());
        for (Entity entity2 : potentialTargets) {
            Vec3d hitPoint;
            double distSq;
            AxisAlignedBB entityBox = entity2.func_174813_aQ().func_186662_g((double)entity2.func_70111_Y());
            RayTraceResult interceptResult = entityBox.func_72327_a(eyePosition, reachVector);
            if (entityBox.func_72318_a(eyePosition)) {
                if (!(closestEntityDistSq >= 0.0)) continue;
                pointedEntity = entity2;
                resultRayTrace = new RayTraceResult(entity2, eyePosition);
                closestEntityDistSq = 0.0;
                continue;
            }
            if (interceptResult == null || !((distSq = eyePosition.func_72436_e(hitPoint = interceptResult.field_72307_f)) < closestEntityDistSq) && closestEntityDistSq != 0.0) continue;
            if (entity2 != mc.func_175606_aa() || mc.field_71474_y.field_74320_O <= 0) {
                // empty if block
            }
            pointedEntity = entity2;
            resultRayTrace = new RayTraceResult(entity2, hitPoint);
            closestEntityDistSq = distSq;
        }
        return resultRayTrace;
    }

    @SideOnly(value=Side.CLIENT)
    private static RayTraceResult createMissRayTrace(@Nullable RayTraceResult original) {
        Vec3d missPos = original != null ? original.field_72307_f : Minecraft.func_71410_x().field_71439_g.func_174824_e(1.0f);
        EnumFacing side = original != null ? original.field_178784_b : EnumFacing.UP;
        BlockPos blockPos = original != null ? original.func_178782_a() : new BlockPos(missPos);
        return new RayTraceResult(RayTraceResult.Type.MISS, missPos, side, blockPos);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    private static Entity findExtendedMouseOverEntity(EntityPlayer player, double range) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity pointedEntity = null;
        Vec3d eyePos = player.func_174824_e(mc.func_184121_ak());
        Vec3d lookVec = player.func_70676_i(mc.func_184121_ak());
        Vec3d lookEnd = eyePos.func_178787_e(lookVec.func_186678_a(range));
        double closestEntityDistSq = range * range;
        AxisAlignedBB searchBox = player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range).func_72314_b(1.0, 1.0, 1.0);
        List list = mc.field_71441_e.func_175674_a((Entity)player, searchBox, entity -> entity != null && entity.func_70067_L());
        for (Entity entity2 : list) {
            double distSq;
            AxisAlignedBB entityBB = entity2.func_174813_aQ().func_186662_g((double)entity2.func_70111_Y());
            RayTraceResult intercept = entityBB.func_72327_a(eyePos, lookEnd);
            if (entityBB.func_72318_a(eyePos)) {
                if (!(closestEntityDistSq >= 0.0)) continue;
                pointedEntity = entity2;
                closestEntityDistSq = 0.0;
                continue;
            }
            if (intercept == null || !((distSq = eyePos.func_72436_e(intercept.field_72307_f)) < closestEntityDistSq) && closestEntityDistSq != 0.0 || entity2.func_98034_c(player)) continue;
            pointedEntity = entity2;
            closestEntityDistSq = distSq;
        }
        return pointedEntity;
    }
}

