/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.handlers;

import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PressureHandler {
    private static final double SURFACE_PRESSURE = 1.0;
    private static final double PRESSURE_INCREASE_PER_BLOCK = 0.1;
    private static final double DANGEROUS_PRESSURE_THRESHOLD = 3.0;
    private static final double LETHAL_PRESSURE_THRESHOLD = 4.0;
    private static final float DROWNING_DAMAGE = 4.0f;
    private static final int EFFECT_DURATION = 40;
    private static final int DAMAGE_INTERVAL = 20;
    private static final int AIR_REDUCTION_INTERVAL = 5;
    private static final int AIR_REDUCTION_AMOUNT = 2;

    public static double getPressure(EntityPlayer player) {
        BlockPos pos;
        if (!player.func_70090_H()) {
            return 1.0;
        }
        BlockPos surfacePos = pos = player.func_180425_c();
        while (surfacePos.func_177956_o() < player.field_70170_p.func_72800_K() && player.field_70170_p.func_180495_p(surfacePos).func_185904_a() == Material.field_151586_h) {
            surfacePos = surfacePos.func_177984_a();
        }
        int depth = surfacePos.func_177956_o() - pos.func_177956_o();
        return 1.0 + (double)depth * 0.1;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof EntityPlayerMP && player.func_70090_H()) {
            PressureHandler.applyPressureEffects((EntityPlayer)((EntityPlayerMP)player));
        }
    }

    public static void applyPressureEffects(EntityPlayer player) {
        IMinePieceData playerData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (playerData != null && PressureHandler.isFishman(playerData)) {
            return;
        }
        double pressure = PressureHandler.getPressure(player);
        if (pressure >= 4.0) {
            if (player.field_70173_aa % 20 == 0 && !player.field_70170_p.field_72995_K) {
                player.func_70097_a(DamageSource.field_76369_e, 4.0f);
            }
            PressureHandler.spawnPressureBubbles(player);
        } else if (pressure >= 3.0) {
            if (player.field_70173_aa % 5 == 0) {
                int currentAir = player.func_70086_ai();
                player.func_70050_g(Math.max(0, currentAir - 2));
            }
            player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 40, 0, false, true));
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 0, false, true));
            PressureHandler.spawnPressureBubbles(player);
        }
    }

    private static boolean isFishman(IMinePieceData playerData) {
        return playerData.getRace() == MinePieceRaces.FISHMAN || playerData.getRace() != null && "fishman".equalsIgnoreCase(playerData.getRace().getName());
    }

    private static void spawnPressureBubbles(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && (double)player.field_70170_p.field_73012_v.nextFloat() < 0.2) {
            for (int i = 0; i < 2; ++i) {
                double xOffset = (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N;
                double yOffset = player.field_70170_p.field_73012_v.nextDouble() * (double)player.field_70131_O;
                double zOffset = (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N;
                player.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, player.field_70165_t + xOffset, player.field_70163_u + yOffset, player.field_70161_v + zOffset, 0.0, 0.1, 0.0, new int[0]);
            }
        }
    }
}

