/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.handlers;

import fr.minepiece.MinePiece;
import fr.minepiece.common.items.misc.CordageItem;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.CordageSyncPacket;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class PlayerLeashHandler {
    private static final Map<UUID, LeashInfo> leashedPlayers = new ConcurrentHashMap<UUID, LeashInfo>();
    private static final Map<UUID, LeashAttempt> leashAttempts = new ConcurrentHashMap<UUID, LeashAttempt>();
    public static final double MAX_LEASH_DISTANCE = 10.0;
    public static final double MIN_LEASH_DISTANCE = 3.0;
    public static final double PULL_STRENGTH = 0.5;
    public static final double MAX_PULL_SPEED = 0.4;
    public static final int LEASHING_DURATION_TICKS = 20;
    public static final int ITEM_COOLDOWN_TICKS = 60;
    public static final double MAX_ATTEMPT_DISTANCE = 8.0;
    public static final int MAX_LEASH_DURATION_TICKS = 1200;

    public static void leashPlayer(EntityPlayer holder, EntityPlayer target) {
        if (holder == null || target == null || holder == target) {
            return;
        }
        UUID holderUUID = holder.func_110124_au();
        UUID targetUUID = target.func_110124_au();
        World world = holder.field_70170_p;
        PlayerLeashHandler.cancelLeashAttempt(holderUUID, false);
        PlayerLeashHandler.unleashHeldPlayer(holderUUID);
        PlayerLeashHandler.unleashPlayer(targetUUID, false);
        long startTime = world.func_82737_E();
        LeashInfo info = new LeashInfo(holderUUID, startTime);
        leashedPlayers.put(targetUUID, info);
        Item mainHandItem = holder.func_184614_ca().func_77973_b();
        Item offHandItem = holder.func_184592_cb().func_77973_b();
        if (mainHandItem instanceof CordageItem) {
            holder.func_184811_cZ().func_185145_a(mainHandItem, 60);
        }
        if (offHandItem instanceof CordageItem) {
            holder.func_184811_cZ().func_185145_a(offHandItem, 60);
        }
        CordageSyncPacket packet = new CordageSyncPacket(targetUUID, holderUUID, true);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(target.field_71093_bK, target.field_70165_t, target.field_70163_u, target.field_70161_v, 64.0);
        ModPackets.NETWORK.sendToAllAround((IMessage)packet, point);
        holder.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.success.holder.leashed", new Object[]{target.func_70005_c_()}), true);
        target.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.success.target.leashed", new Object[]{holder.func_70005_c_()}), true);
        world.func_184148_a(null, holder.field_70165_t, holder.field_70163_u, holder.field_70161_v, SoundEvents.field_187748_db, SoundCategory.PLAYERS, 0.7f, 1.0f);
    }

    public static boolean startLeashAttempt(EntityPlayer holder, EntityPlayer target, EnumHand hand, Item itemUsed) {
        if (holder == null || target == null || holder == target || hand == null || itemUsed == null) {
            return false;
        }
        if (holder.field_70170_p.field_72995_K) {
            return false;
        }
        UUID holderUUID = holder.func_110124_au();
        UUID targetUUID = target.func_110124_au();
        if (PlayerLeashHandler.isAttemptingLeash(holderUUID)) {
            holder.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.fail.holder_already_attempting", new Object[0]), true);
            return false;
        }
        if (PlayerLeashHandler.isTargetInLeashAttempt(targetUUID)) {
            holder.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.fail.target_being_leashed", new Object[]{target.func_70005_c_()}), true);
            return false;
        }
        if (PlayerLeashHandler.isLeashed(target)) {
            holder.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.fail.target_already_leashed", new Object[]{target.func_70005_c_()}), true);
            return false;
        }
        if (holder.func_70068_e((Entity)target) > 64.0) {
            holder.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.fail.target_too_far_initial", new Object[]{target.func_70005_c_()}), true);
            return false;
        }
        LeashAttempt attempt = new LeashAttempt(holderUUID, targetUUID, hand, holder.field_70170_p.func_82737_E(), itemUsed);
        leashAttempts.put(holderUUID, attempt);
        holder.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.attempt.holder.start", new Object[]{target.func_70005_c_()}), true);
        target.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.attempt.target.start", new Object[]{holder.func_70005_c_()}), true);
        holder.field_70170_p.func_184148_a(null, holder.field_70165_t, holder.field_70163_u, holder.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 0.5f, 1.2f);
        return true;
    }

    public static void cancelLeashAttempt(UUID holderUUID, boolean notify) {
        LeashAttempt removed = leashAttempts.remove(holderUUID);
        if (removed != null && notify) {
            System.out.println("Cancelled leash attempt for: " + holderUUID);
            Object var3_3 = null;
        }
    }

    public static boolean isAttemptingLeash(UUID holderUUID) {
        return leashAttempts.containsKey(holderUUID);
    }

    public static boolean isTargetInLeashAttempt(UUID targetUUID) {
        for (LeashAttempt attempt : leashAttempts.values()) {
            if (!attempt.targetUUID.equals(targetUUID)) continue;
            return true;
        }
        return false;
    }

    public static void unleashPlayer(UUID targetUUID, boolean applyCooldownAndSound) {
        LeashInfo removedInfo = leashedPlayers.remove(targetUUID);
        if (removedInfo != null) {
            UUID holderUUID = removedInfo.holderUUID;
            EntityPlayer holder = PlayerLeashHandler.getPlayerFromServer(holderUUID);
            EntityPlayer target = PlayerLeashHandler.getPlayerFromServer(targetUUID);
            CordageSyncPacket packet = new CordageSyncPacket(targetUUID, null, false);
            EntityPlayer targetPlayer = PlayerLeashHandler.getPlayerFromServer(targetUUID);
            EntityPlayer holderPlayer = PlayerLeashHandler.getPlayerFromServer(holderUUID);
            NetworkRegistry.TargetPoint point = null;
            if (targetPlayer != null) {
                point = new NetworkRegistry.TargetPoint(targetPlayer.field_71093_bK, targetPlayer.field_70165_t, targetPlayer.field_70163_u, targetPlayer.field_70161_v, 64.0);
            } else if (holderPlayer != null) {
                point = new NetworkRegistry.TargetPoint(holderPlayer.field_71093_bK, holderPlayer.field_70165_t, holderPlayer.field_70163_u, holderPlayer.field_70161_v, 64.0);
            }
            if (point != null) {
                ModPackets.NETWORK.sendToAllAround((IMessage)packet, point);
            } else {
                MinePiece.LOGGER.warn("WARN: Could not determine target point for sending unleash packet for " + targetUUID);
            }
            if (holder != null) {
                holder.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.break.holder", new Object[0]), true);
                if (applyCooldownAndSound) {
                    Item mainHandItem = holder.func_184614_ca().func_77973_b();
                    Item offHandItem = holder.func_184592_cb().func_77973_b();
                    if (mainHandItem instanceof CordageItem) {
                        holder.func_184811_cZ().func_185145_a(mainHandItem, 60);
                    }
                    if (offHandItem instanceof CordageItem) {
                        holder.func_184811_cZ().func_185145_a(offHandItem, 60);
                    }
                    holder.field_70170_p.func_184148_a(null, holder.field_70165_t, holder.field_70163_u, holder.field_70161_v, SoundEvents.field_187746_da, SoundCategory.PLAYERS, 0.7f, 1.0f);
                }
            }
            if (target != null) {
                target.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.break.target", new Object[0]), true);
            }
        }
    }

    public static void unleashHeldPlayer(UUID holderUUID) {
        UUID targetToRemove = null;
        for (Map.Entry<UUID, LeashInfo> entry : leashedPlayers.entrySet()) {
            if (!entry.getValue().holderUUID.equals(holderUUID)) continue;
            targetToRemove = entry.getKey();
            break;
        }
        if (targetToRemove != null) {
            PlayerLeashHandler.unleashPlayer(targetToRemove, true);
        }
    }

    public static boolean isLeashed(EntityPlayer player) {
        return player != null && leashedPlayers.containsKey(player.func_110124_au());
    }

    @Nullable
    public static EntityPlayer getLeashHolder(EntityPlayer target) {
        LeashInfo info;
        if (target != null && !target.field_70170_p.field_72995_K && (info = leashedPlayers.get(target.func_110124_au())) != null) {
            return target.field_70170_p.func_152378_a(info.holderUUID);
        }
        return null;
    }

    @Nullable
    public static EntityPlayer getLeashedPlayer(EntityPlayer holder) {
        if (holder != null && !holder.field_70170_p.field_72995_K) {
            UUID holderUUID = holder.func_110124_au();
            for (Map.Entry<UUID, LeashInfo> entry : leashedPlayers.entrySet()) {
                if (!entry.getValue().holderUUID.equals(holderUUID)) continue;
                return holder.field_70170_p.func_152378_a(entry.getKey());
            }
        }
        return null;
    }

    @Nullable
    private static EntityPlayer getPlayerFromServer(UUID uuid) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
        }
        return null;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        UUID playerUUID = player.func_110124_au();
        World world = player.field_70170_p;
        if (leashAttempts.containsKey(playerUUID)) {
            LeashAttempt attempt = leashAttempts.get(playerUUID);
            EntityPlayer holder = player;
            EntityPlayer target = world.func_152378_a(attempt.targetUUID);
            boolean cancel = false;
            TextComponentTranslation cancelReason = null;
            if (target == null || target.field_70128_L) {
                cancel = true;
                cancelReason = new TextComponentTranslation("message.cordage.attempt.cancel.holder.reason.target_invalid", new Object[0]);
            } else if (holder.field_71093_bK != target.field_71093_bK) {
                cancel = true;
                cancelReason = new TextComponentTranslation("message.cordage.attempt.cancel.holder.reason.dimension", new Object[0]);
            } else if (holder.func_184586_b(attempt.hand).func_77973_b() != attempt.leashItemType) {
                cancel = true;
                cancelReason = new TextComponentTranslation("message.cordage.attempt.cancel.holder.reason.item_not_held", new Object[0]);
            } else if (holder.func_70068_e((Entity)target) > 64.0) {
                cancel = true;
                cancelReason = new TextComponentTranslation("message.cordage.attempt.cancel.holder.reason.distance", new Object[0]);
            } else if (PlayerLeashHandler.isLeashed(target)) {
                cancel = true;
                cancelReason = new TextComponentTranslation("message.cordage.attempt.cancel.holder.reason.target_leashed_elsewhere", new Object[]{target.func_70005_c_()});
            }
            if (cancel) {
                PlayerLeashHandler.cancelLeashAttempt(playerUUID, false);
                holder.func_146105_b((ITextComponent)cancelReason, true);
                if (target != null) {
                    target.func_146105_b((ITextComponent)new TextComponentTranslation("message.cordage.attempt.cancel.target.cancelled", new Object[]{holder.func_70005_c_()}), true);
                }
                world.func_184148_a(null, holder.field_70165_t, holder.field_70163_u, holder.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.0f);
            } else {
                long currentTime = world.func_82737_E();
                if (currentTime >= attempt.startTick + 20L) {
                    PlayerLeashHandler.leashPlayer(holder, target);
                    if (!holder.field_71075_bZ.field_75098_d) {
                        holder.func_184586_b(attempt.hand).func_190918_g(1);
                    }
                    leashAttempts.remove(playerUUID);
                } else if (currentTime % 4L == 0L) {
                    Vec3d start = holder.func_174791_d().func_178787_e(new Vec3d(0.0, (double)holder.func_70047_e() * 0.7, 0.0));
                    Vec3d end = target.func_174791_d().func_178787_e(new Vec3d(0.0, (double)target.func_70047_e() * 0.7, 0.0));
                    Vec3d vec = end.func_178788_d(start);
                    double len = vec.func_72433_c();
                    if (len > 0.1) {
                        Vec3d step = vec.func_186678_a(1.0 / len);
                        for (double d = 0.2; d < len; d += 0.3) {
                            Vec3d particlePos = start.func_178787_e(step.func_186678_a(d));
                            world.func_175688_a(EnumParticleTypes.CRIT_MAGIC, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
        }
        long currentTime = world.func_82737_E();
        if (leashedPlayers.containsKey(playerUUID)) {
            LeashInfo info = leashedPlayers.get(playerUUID);
            EntityPlayer leashedPlayer = player;
            EntityPlayer holder = world.func_152378_a(info.holderUUID);
            boolean breakLeash = false;
            String breakReason = "";
            if (holder == null || holder.field_70128_L) {
                breakLeash = true;
                breakReason = "Holder logged out or died";
            } else if (holder.field_71093_bK != leashedPlayer.field_71093_bK) {
                breakLeash = true;
                breakReason = "Dimension mismatch";
            } else {
                long leashDuration = currentTime - info.startTime;
                if (leashDuration >= 1200L) {
                    breakLeash = true;
                    breakReason = "Leash duration expired (" + leashDuration / 20L + "s)";
                } else {
                    double distanceSq = leashedPlayer.func_70068_e((Entity)holder);
                    if (distanceSq > 100.0) {
                        breakLeash = true;
                        breakReason = "Max distance exceeded (" + String.format("%.1f", Math.sqrt(distanceSq)) + "m)";
                    } else if (distanceSq > 9.0) {
                        Vec3d vecToHolder = holder.func_174791_d().func_178788_d(leashedPlayer.func_174791_d());
                        Vec3d dirToHolder = vecToHolder.func_72432_b();
                        double pullRange = 7.0;
                        double pullFactor = pullRange > 0.0 ? 0.5 * Math.min(1.0, (Math.sqrt(distanceSq) - 3.0) / pullRange) : 0.5;
                        double targetMotionX = Math.min(0.4, Math.max(-0.4, dirToHolder.field_72450_a * pullFactor));
                        double targetMotionY = Math.min(0.4, Math.max(-0.4, dirToHolder.field_72448_b * pullFactor * 0.5));
                        double targetMotionZ = Math.min(0.4, Math.max(-0.4, dirToHolder.field_72449_c * pullFactor));
                        leashedPlayer.func_70024_g(targetMotionX, targetMotionY, targetMotionZ);
                        leashedPlayer.field_70133_I = true;
                    }
                }
            }
            if (breakLeash) {
                PlayerLeashHandler.unleashPlayer(playerUUID, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player != null && !event.player.field_70170_p.field_72995_K) {
            UUID loggedOutUUID = event.player.func_110124_au();
            System.out.println("Player logged out: " + event.player.func_70005_c_());
            PlayerLeashHandler.cancelLeashAttempt(loggedOutUUID, false);
            PlayerLeashHandler.cancelTargetAttempt(loggedOutUUID);
            PlayerLeashHandler.unleashPlayer(loggedOutUUID, false);
            PlayerLeashHandler.unleashHeldPlayer(loggedOutUUID);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityPlayer deadPlayer = (EntityPlayer)event.getEntityLiving();
            UUID deadUUID = deadPlayer.func_110124_au();
            System.out.println("Player died: " + deadPlayer.func_70005_c_());
            PlayerLeashHandler.cancelLeashAttempt(deadUUID, false);
            PlayerLeashHandler.cancelTargetAttempt(deadUUID);
            PlayerLeashHandler.unleashPlayer(deadUUID, false);
            PlayerLeashHandler.unleashHeldPlayer(deadUUID);
        }
    }

    @SubscribeEvent
    public static void onDimChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player != null && !event.player.field_70170_p.field_72995_K) {
            UUID playerUUID = event.player.func_110124_au();
            System.out.println("Player changed dimension: " + event.player.func_70005_c_());
            PlayerLeashHandler.cancelLeashAttempt(playerUUID, false);
            PlayerLeashHandler.cancelTargetAttempt(playerUUID);
            PlayerLeashHandler.unleashPlayer(playerUUID, false);
            PlayerLeashHandler.unleashHeldPlayer(playerUUID);
        }
    }

    private static void cancelTargetAttempt(UUID targetUUID) {
        UUID holderToCancel = null;
        Iterator<Map.Entry<UUID, LeashAttempt>> iterator = leashAttempts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, LeashAttempt> entry = iterator.next();
            if (!entry.getValue().targetUUID.equals(targetUUID)) continue;
            holderToCancel = entry.getKey();
            iterator.remove();
            System.out.println("Cancelled target attempt involving target: " + targetUUID);
            break;
        }
    }

    private static class LeashAttempt {
        final UUID holderUUID;
        final UUID targetUUID;
        final EnumHand hand;
        final long startTick;
        final Item leashItemType;

        LeashAttempt(UUID holderUUID, UUID targetUUID, EnumHand hand, long startTick, Item leashItemType) {
            this.holderUUID = holderUUID;
            this.targetUUID = targetUUID;
            this.hand = hand;
            this.startTick = startTick;
            this.leashItemType = leashItemType;
        }
    }

    private static class LeashInfo {
        final UUID holderUUID;
        final long startTime;

        LeashInfo(UUID holderUUID, long startTime) {
            this.holderUUID = holderUUID;
            this.startTime = startTime;
        }
    }
}

