/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.handlers;

import fr.minepiece.common.capability.knockout.IKOState;
import fr.minepiece.common.capability.knockout.KOStateStorage;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import fr.minepiece.common.init.ModPotions;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.CancelMovementPacket;
import fr.minepiece.common.network.packets.PlayerKOSyncPacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class PlayerKOHandler {
    public static final int KO_COOLDOWN_MILLIS = 15000;
    public static final float KO_HEALTH_THRESHOLD = 0.5f;
    public static final float KO_MOVEMENT_SPEED = 0.03f;
    public static final int KO_EFFECT_DURATION = 12000;
    public static final int KO_EFFECT_DURATION_SELF = 6000;
    public static final int KO_EFFECT_DURATION_AFTER = 2400;
    private static HashSet<UUID> playersInLimbo = new HashSet();
    private static final Map<UUID, ItemStack[]> savedInventories = new HashMap<UUID, ItemStack[]>();

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (PlayerKOHandler.isPlayerInKO(player)) {
            System.out.println("PLAYER IS IN KO");
            event.setCanceled(true);
            return;
        }
        if (player.func_110143_aJ() - event.getAmount() <= 0.0f) {
            if (!PlayerKOHandler.canPlayerBeKOAgain(player)) {
                return;
            }
            if (event.getAmount() < player.func_110138_aP() && event.getSource() != DamageSource.field_76380_i && event.getSource() != DamageSource.field_76379_h && !event.getSource().func_151517_h()) {
                event.setCanceled(true);
                PlayerKOHandler.knockoutPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        IKOState koState;
        EntityPlayerMP player;
        if (event.player instanceof EntityPlayerMP && (player = (EntityPlayerMP)event.player).hasCapability(KOStateStorage.KO_STATE_CAPABILITY, null) && (koState = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null)) != null) {
            PlayerKOHandler.syncKOState(player, koState.isPlayerInKO());
            if (koState.isPlayerInKO()) {
                PlayerKOHandler.applyKOEffects(player);
            }
        }
    }

    public static void knockoutPlayer(EntityPlayer player) {
        if (player == null || !(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        IKOState koState = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        IPlayerModifications playerModifications = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (koState == null || playerModifications == null) {
            return;
        }
        koState.setKOState(true);
        koState.setLastKOTime(System.currentTimeMillis());
        koState.clientSync(playerMP);
        playerModifications.setPose("knocked_out");
        playerModifications.clientSync(playerMP);
        PlayerKOHandler.applyKOEffects(playerMP);
    }

    public static void selfRevive(EntityPlayer player) {
        if (player == null || !(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        IKOState koState = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        IPlayerModifications playerModifications = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (koState == null || playerModifications == null) {
            return;
        }
        koState.setKOState(false);
        koState.clientSync(playerMP);
        playerModifications.setPose("default");
        playerModifications.clientSync((EntityPlayerMP)player);
        PlayerKOHandler.removeSelfKOEffects(playerMP);
        PlayerKOHandler.respawnPlayer(playerMP);
    }

    private static void respawnPlayer(EntityPlayerMP playerMP) {
        BlockPos bedPos = playerMP.getBedLocation(playerMP.field_71093_bK);
        if (bedPos == null) {
            BlockPos mainWorldSpawnPos = playerMP.field_70170_p.func_175694_M();
            double px = mainWorldSpawnPos.func_177958_n();
            double py = mainWorldSpawnPos.func_177956_o();
            double pz = mainWorldSpawnPos.func_177952_p();
            Float pyaw = Float.valueOf(playerMP.field_70177_z);
            Float ppitch = Float.valueOf(playerMP.field_70125_A);
            int pdim = 0;
            PlayerKOHandler.TeleportPlayerToSC(playerMP, px, py, pz, pyaw.floatValue(), ppitch.floatValue(), pdim);
        } else {
            double px = bedPos.func_177958_n();
            double py = bedPos.func_177956_o();
            double pz = bedPos.func_177952_p();
            Float pyaw = Float.valueOf(playerMP.field_70177_z);
            Float ppitch = Float.valueOf(playerMP.field_70125_A);
            int pdim = 0;
            PlayerKOHandler.TeleportPlayerToSC(playerMP, px, py, pz, pyaw.floatValue(), ppitch.floatValue(), pdim);
        }
    }

    public static void TeleportPlayerToSC(EntityPlayerMP fromPlayer, double x, double y, double z, float yaw, float pitch, int destDim) {
        Integer pdim;
        double px = Math.round(fromPlayer.field_70165_t - 0.5);
        double py = Math.round(fromPlayer.field_70163_u - 0.5);
        double pz = Math.round(fromPlayer.field_70161_v - 0.5);
        Float pyaw = Float.valueOf(fromPlayer.field_70177_z);
        Float ppitch = Float.valueOf(fromPlayer.field_70125_A);
        Integer originDim = pdim = Integer.valueOf(fromPlayer.field_71093_bK);
        String newGoBackLocation = px + "," + py + "," + pz + "," + pyaw + "," + ppitch + "," + pdim;
        px = Math.round(x - 0.5);
        py = Math.round(y - 0.5);
        pz = Math.round(z - 0.5);
        pyaw = Float.valueOf(yaw);
        ppitch = Float.valueOf(pitch);
        pdim = destDim;
        if (originDim != pdim && fromPlayer.field_71093_bK != pdim) {
            fromPlayer.field_71133_b.func_184103_al().func_187242_a(fromPlayer, pdim.intValue());
        }
        int yLimitTop = fromPlayer.field_70170_p.func_72940_L();
        boolean yLimitBot = true;
        while (!(!(py < (double)yLimitTop) || PlayerKOHandler.canSpawnInsideBlock((EntityPlayer)fromPlayer, px, py, pz) && PlayerKOHandler.canSpawnInsideBlock((EntityPlayer)fromPlayer, px, py + 1.0, pz))) {
            py += 1.0;
        }
        while (py > (double)yLimitBot && PlayerKOHandler.canSpawnInsideBlock((EntityPlayer)fromPlayer, px, py - 1.0, pz) && PlayerKOHandler.canSpawnInsideBlock((EntityPlayer)fromPlayer, px, py, pz)) {
            py -= 1.0;
        }
        BlockPos posBelowFeet = new BlockPos(px, py - 1.0, pz);
        if (py > (double)yLimitBot && (fromPlayer.field_70170_p.func_180495_p(posBelowFeet).func_177230_c() == Blocks.field_150353_l || fromPlayer.field_70170_p.func_180495_p(posBelowFeet).func_177230_c() == Blocks.field_150356_k)) {
            fromPlayer.field_70170_p.func_175656_a(posBelowFeet, Blocks.field_150347_e.func_176223_P());
        }
        PlayerKOHandler.TeleportPlayerTo(fromPlayer, px, py, pz, pyaw.floatValue(), ppitch.floatValue(), pdim);
    }

    public static void TeleportPlayerTo(EntityPlayerMP player, double x, double y, double z, float yaw, float pitch, int destDim) {
        if (player.field_71093_bK != destDim) {
            player.field_71133_b.func_184103_al().func_187242_a(player, destDim);
        }
        player.func_70012_b(x + 0.5, y, z + 0.5, yaw, pitch);
        player.func_70634_a(x + 0.5, y, z + 0.5);
    }

    public static boolean canSpawnInsideBlock(EntityPlayer player, double x, double y, double z) {
        return PlayerKOHandler.canSpawnInsideBlock(player, (int)x, (int)y, (int)z);
    }

    public static boolean canSpawnInsideBlock(EntityPlayer player, int x, int y, int z) {
        World world = player.field_70170_p;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState iBlockState = world.func_180495_p(pos);
        Block blockID = iBlockState.func_177230_c();
        return blockID.func_176205_b((IBlockAccess)world, pos) && !blockID.func_149688_o(iBlockState).func_76224_d() || blockID == Blocks.field_150324_C;
    }

    public static void adminRevive(EntityPlayer player) {
        if (player == null || !(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        IKOState koState = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        IPlayerModifications playerModifications = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (koState == null || playerModifications == null) {
            return;
        }
        koState.setKOState(false);
        koState.clientSync(playerMP);
        playerModifications.setPose("default");
        playerModifications.clientSync((EntityPlayerMP)player);
        PlayerKOHandler.removeAdminKOEffets(playerMP);
    }

    private static void applyKOEffects(EntityPlayerMP player) {
        player.func_70690_d(new PotionEffect(ModPotions.KNOCKED_OUT_EFFECT, 12000, 2, true, false));
        ModPackets.NETWORK.sendTo((IMessage)new CancelMovementPacket(player.func_110124_au(), true), player);
        player.func_70606_j(0.5f);
    }

    private static void removeAdminKOEffets(EntityPlayerMP player) {
        player.func_184589_d(ModPotions.KNOCKED_OUT_EFFECT);
        player.func_70606_j(Math.max(player.func_110143_aJ(), 20.0f));
        ModPackets.NETWORK.sendTo((IMessage)new CancelMovementPacket(player.func_110124_au(), false), player);
    }

    public static void removeNaturalKOEffects(EntityPlayerMP player) {
        player.func_184589_d(ModPotions.KNOCKED_OUT_EFFECT);
        player.func_70690_d(new PotionEffect(ModPotions.KNOCKED_OUT_EFFECT, 2400, 0, true, false));
        ModPackets.NETWORK.sendTo((IMessage)new CancelMovementPacket(player.func_110124_au(), false), player);
        player.func_70606_j(Math.max(player.func_110143_aJ(), 2.0f));
    }

    private static void removeSelfKOEffects(EntityPlayerMP player) {
        player.func_184589_d(ModPotions.KNOCKED_OUT_EFFECT);
        player.func_70690_d(new PotionEffect(ModPotions.KNOCKED_OUT_EFFECT, 6000, 1, true, false));
        ModPackets.NETWORK.sendTo((IMessage)new CancelMovementPacket(player.func_110124_au(), false), player);
        player.func_70606_j(Math.max(player.func_110143_aJ(), 2.0f));
    }

    private static void syncKOState(EntityPlayerMP player, boolean isKO) {
        ModPackets.NETWORK.sendToAll((IMessage)PlayerKOSyncPacket.fromPlayer(player, isKO));
    }

    public static void syncClientKOState(EntityPlayerMP player, boolean isKO) {
        PlayerKOHandler.syncKOState(player, isKO);
    }

    public static boolean canPlayerBeKOAgain(EntityPlayer player) {
        if (player == null || !player.hasCapability(KOStateStorage.KO_STATE_CAPABILITY, null)) {
            return true;
        }
        IKOState koState = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        return koState != null && koState.canBeKOAgain(System.currentTimeMillis(), 15000L);
    }

    public static boolean isPlayerInKO(EntityPlayer player) {
        IKOState koState = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        return koState != null && koState.isPlayerInKO();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IKOState koState = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        IPlayerModifications playerModifications = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (koState == null || playerModifications == null) {
            return;
        }
        if (PlayerKOHandler.isPlayerInKO(player)) {
            long last = koState.getLastKOTime();
            if (System.currentTimeMillis() - last > 600000L) {
                koState.setKOState(false);
                koState.clientSync((EntityPlayerMP)player);
                playerModifications.setPose("default");
                playerModifications.clientSync((EntityPlayerMP)player);
                PlayerKOHandler.removeNaturalKOEffects((EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (PlayerKOHandler.isPlayerInKO(player)) {
            if (Math.abs(player.field_70159_w) > (double)0.03f) {
                player.field_70159_w = Math.signum(player.field_70159_w) * (double)0.03f;
            }
            if (Math.abs(player.field_70179_y) > (double)0.03f) {
                player.field_70179_y = Math.signum(player.field_70179_y) * (double)0.03f;
            }
            if (!player.field_70122_E && player.field_71075_bZ.field_75100_b) {
                player.field_70181_x = Math.min(player.field_70181_x, 0.0);
                player.field_71075_bZ.field_75100_b = false;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (PlayerKOHandler.isPlayerInKO(event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }
}

