/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.handlers;

import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="minepiece")
public class CraftLimitHandler {
    private static final Map<UUID, Integer> lastResetDayByPlayer = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> totalCraftsByPlayer = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> lastCraftLimitByPlayer = new HashMap<UUID, Integer>();
    private static final int CHECK_INTERVAL = 100;

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            CraftLimitHandler.checkAndResetCraftLimit((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            if (player.field_70170_p.func_72820_D() % 100L == 0L) {
                CraftLimitHandler.checkAndResetCraftLimit(player);
                CraftLimitHandler.checkAndTrackCrafts(player);
            }
        }
    }

    private static int getCurrentMinecraftDay(World world) {
        return (int)(world.func_72820_D() / 24000L);
    }

    private static void checkAndResetCraftLimit(EntityPlayerMP player) {
        UUID playerUUID;
        int lastResetDay;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IMinePieceData playerData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (playerData == null) {
            return;
        }
        int currentDay = CraftLimitHandler.getCurrentMinecraftDay(player.field_70170_p);
        if (currentDay > (lastResetDay = lastResetDayByPlayer.getOrDefault(playerUUID = player.func_110124_au(), 0).intValue()) && playerData.getJob() != null) {
            int baseLimit = playerData.getJob().getDailyCraftLimit();
            playerData.setDailyCraftLimit(baseLimit);
            lastResetDayByPlayer.put(playerUUID, currentDay);
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aVotre limite quotidienne de craft a \u00e9t\u00e9 r\u00e9initialis\u00e9e \u00e0 \u00a7c" + baseLimit + "\u00a7a pour votre m\u00e9tier de \u00a7c" + playerData.getJob().getName()));
            playerData.clientSync(player);
        }
    }

    private static void checkAndTrackCrafts(EntityPlayerMP player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IMinePieceData playerData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (playerData == null) {
            return;
        }
        UUID playerUUID = player.func_110124_au();
        int currentLimit = playerData.getDailyCraftLimit();
        if (lastCraftLimitByPlayer.containsKey(playerUUID)) {
            int lastLimit = lastCraftLimitByPlayer.get(playerUUID);
            if (currentLimit < lastLimit) {
                int craftsPerformed = lastLimit - currentLimit;
                int totalCrafts = totalCraftsByPlayer.getOrDefault(playerUUID, 0) + craftsPerformed;
                totalCraftsByPlayer.put(playerUUID, totalCrafts);
            }
        } else {
            lastCraftLimitByPlayer.put(playerUUID, currentLimit);
        }
        lastCraftLimitByPlayer.put(playerUUID, currentLimit);
    }

    public static int getTotalCraftsPerformed(EntityPlayer player) {
        UUID playerUUID = player.func_110124_au();
        return totalCraftsByPlayer.getOrDefault(playerUUID, 0);
    }

    public static void forceResetCraftLimit(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IMinePieceData playerData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (playerData == null) {
            return;
        }
        UUID playerUUID = player.func_110124_au();
        lastCraftLimitByPlayer.put(playerUUID, playerData.getDailyCraftLimit());
        int baseLimit = playerData.getJob() != null ? playerData.getJob().getDailyCraftLimit() : 10;
        playerData.setDailyCraftLimit(baseLimit);
        lastResetDayByPlayer.put(playerUUID, CraftLimitHandler.getCurrentMinecraftDay(player.field_70170_p));
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_145747_a((ITextComponent)new TextComponentString("\u00a7aVotre limite quotidienne de craft a \u00e9t\u00e9 manuellement r\u00e9initialis\u00e9e \u00e0 \u00a7c" + baseLimit));
            playerData.clientSync((EntityPlayerMP)player);
        }
    }
}

