/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.events;

import fr.minepiece.common.items.armors.TieredItemArmor;
import fr.minepiece.common.items.weapons.TieredItemSword;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="minepiece")
public class TieredItemHandler {
    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.register(TieredItemHandler.class);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70173_aa % 20 != 0) {
            return;
        }
        TieredItemHandler.checkItemBreak(player.func_184586_b(EnumHand.MAIN_HAND), player, EnumHand.MAIN_HAND);
        TieredItemHandler.checkItemBreak(player.func_184586_b(EnumHand.OFF_HAND), player, EnumHand.OFF_HAND);
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack armorStack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (armorStack.func_190926_b() || !(armorStack.func_77973_b() instanceof TieredItemArmor)) continue;
            TieredItemArmor armorItem = (TieredItemArmor)armorStack.func_77973_b();
            if (armorStack.func_77952_i() < armorItem.getMaxDamage(armorStack) - 1) continue;
            ItemStack brokenStack = armorStack.func_77946_l();
            player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
            armorItem.handleArmorBreak(brokenStack, player);
        }
    }

    private static void checkItemBreak(ItemStack stack, EntityPlayer player, EnumHand hand) {
        if (stack.func_190926_b()) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof TieredItemSword) {
            TieredItemSword swordItem = (TieredItemSword)item;
            if (stack.func_77952_i() >= swordItem.getMaxDamage(stack) - 1) {
                ItemStack brokenStack = stack.func_77946_l();
                player.func_184611_a(hand, ItemStack.field_190927_a);
                swordItem.handleWeaponBreak(brokenStack, player);
            }
        }
    }
}

