/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.events;

import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.capability.thirst.ThirstProvider;
import fr.minepiece.common.init.ModPotions;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ThirstEvents {
    private static final Map<EntityPlayer, Vec3d> lastPositions = new WeakHashMap<EntityPlayer, Vec3d>();

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("minepiece", "thirst"), (ICapabilityProvider)new ThirstProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent event) {
        EntityPlayer player;
        IThirst thirst;
        if (event.getEntityLiving() instanceof EntityPlayer && (thirst = (IThirst)(player = (EntityPlayer)event.getEntityLiving()).getCapability(ThirstProvider.THIRST_CAPABILITY, null)) != null && event.getAmount() != 0.0f) {
            DamageSource source = event.getSource();
            ThirstEvents.addExhaustion(player, source.func_76345_d());
        }
    }

    private static void doThirstEffects(EntityPlayer player, IThirst thirst) {
        float thirstLevel = thirst.getThirstLevel();
        if (thirstLevel <= 0.0f) {
            if (player.field_70170_p.func_72820_D() % 80L == 0L) {
                player.func_70690_d(new PotionEffect(ModPotions.DEHYDRATION_EFFECT, 200, 1));
            }
        } else if (thirstLevel <= 6.0f && player.field_70170_p.func_72820_D() % 400L == 0L) {
            player.func_70690_d(new PotionEffect(ModPotions.DEHYDRATION_EFFECT, 420, 0));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Vec3d lastPos;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (event.player instanceof EntityPlayerMP) {
            ThirstEvents.doThirstEffects(event.player, (IThirst)event.player.getCapability(ThirstProvider.THIRST_CAPABILITY, null));
        }
        if ((lastPos = lastPositions.get(player)) == null) {
            lastPos = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            lastPositions.put(player, lastPos);
            return;
        }
        double dx = player.field_70165_t - lastPos.field_72450_a;
        double dy = player.field_70163_u - lastPos.field_72448_b;
        double dz = player.field_70161_v - lastPos.field_72449_c;
        lastPositions.put(player, new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        if (player.func_184218_aH()) {
            return;
        }
        if (player.func_70055_a(Material.field_151586_h)) {
            int i = Math.round(MathHelper.func_76129_c((float)((float)(dx * dx + dy * dy + dz * dz))) * 100.0f);
            if (i > 0) {
                float exhaustion = 0.01f * (float)i * 0.01f * 2.0f;
                ThirstEvents.addExhaustion(player, exhaustion);
            }
        } else if (player.func_70090_H()) {
            int j = Math.round(MathHelper.func_76129_c((float)((float)(dx * dx + dz * dz))) * 100.0f);
            if (j > 0) {
                float exhaustion = 0.01f * (float)j * 0.01f * 2.0f;
                ThirstEvents.addExhaustion(player, exhaustion);
            }
        } else if (player.func_70617_f_()) {
            if (dy > 0.0) {
                // empty if block
            }
        } else if (player.field_70122_E) {
            int k = Math.round(MathHelper.func_76129_c((float)((float)(dx * dx + dz * dz))) * 100.0f);
            if (k > 0) {
                if (player.func_70051_ag()) {
                    float exhaustion = 0.05f * (float)k * 0.01f * 2.0f;
                    ThirstEvents.addExhaustion(player, exhaustion);
                } else if (player.func_70093_af()) {
                    float exhaustion = 0.0f * (float)k * 0.01f * 2.0f;
                    ThirstEvents.addExhaustion(player, exhaustion);
                } else {
                    float exhaustion = 0.0f * (float)k * 0.01f * 2.0f;
                    ThirstEvents.addExhaustion(player, exhaustion);
                }
            }
        } else if (player.func_184613_cA()) {
            int n = Math.round(MathHelper.func_76129_c((float)((float)(dx * dx + dy * dy + dz * dz))) * 100.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.func_70051_ag()) {
                ThirstEvents.addExhaustion(player, 0.2f);
            } else {
                ThirstEvents.addExhaustion(player, 0.05f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttackEntity(AttackEntityEvent event) {
        ThirstEvents.addExhaustion(event.getEntityPlayer(), 0.1f);
    }

    private static void addExhaustion(EntityPlayer player, float exhaustion) {
        IThirst thirst;
        if (player.func_184812_l_()) {
            return;
        }
        float newExhaustion = exhaustion * 0.85f;
        if (player.func_70644_a(ModPotions.THIRST_EFFECT)) {
            int amplifier = player.func_70660_b(ModPotions.THIRST_EFFECT).func_76458_c();
            newExhaustion += newExhaustion * 0.25f * (float)amplifier;
        }
        if ((thirst = (IThirst)player.getCapability(ThirstProvider.THIRST_CAPABILITY, null)) != null && player instanceof EntityPlayerMP) {
            thirst.addExhaustion((EntityPlayerMP)player, newExhaustion);
            thirst.clientSync((EntityPlayerMP)player);
        }
    }
}

