/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.events;

import fr.minepiece.common.capability.temperature.ITemperature;
import fr.minepiece.common.capability.temperature.RaceTemperatureModifiers;
import fr.minepiece.common.capability.temperature.TemperatureProvider;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.TemperatureSyncPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class TemperatureEvents {
    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            EntityPlayer player;
            ITemperature temp;
            event.addCapability(new ResourceLocation("minepiece", "temperature"), (ICapabilityProvider)new TemperatureProvider());
            if (!((Entity)event.getObject()).field_70170_p.field_72995_K && (temp = (ITemperature)(player = (EntityPlayer)event.getObject()).getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null)) != null) {
                double baseTemp = RaceTemperatureModifiers.getBaseTemperatureForRace(player);
                temp.setBaseTemperature(baseTemp);
                temp.setTemperature(baseTemp);
                if (player instanceof EntityPlayerMP) {
                    ModPackets.NETWORK.sendTo((IMessage)new TemperatureSyncPacket(temp), (EntityPlayerMP)player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        ITemperature oldTemp = (ITemperature)event.getOriginal().getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null);
        ITemperature newTemp = (ITemperature)event.getEntityPlayer().getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null);
        if (oldTemp != null && newTemp != null) {
            newTemp.copy(oldTemp);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayerMP player;
        ITemperature temp;
        if (event.getEntityLiving() instanceof EntityPlayerMP && (temp = (ITemperature)(player = (EntityPlayerMP)event.getEntityLiving()).getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null)) != null) {
            temp.updateTemperature((EntityPlayer)player);
            temp.applyEffects((EntityPlayer)player);
            if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                ModPackets.NETWORK.sendTo((IMessage)new TemperatureSyncPacket(temp), player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && event.getTarget() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            EntityPlayer target = (EntityPlayer)event.getTarget();
            ITemperature temp = (ITemperature)target.getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null);
            if (temp != null) {
                ModPackets.NETWORK.sendTo((IMessage)new TemperatureSyncPacket(temp), player);
            }
        }
    }
}

