/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.events;

import com.artemis.artemislib.compatibilities.sizeCap.ISizeCap;
import com.artemis.artemislib.compatibilities.sizeCap.SizeCapPro;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="minepiece")
public class ScaleEvents {
    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            event.setDistance(event.getDistance() / (player.field_70131_O * 0.6f));
            if (player.field_70131_O < 0.45f) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        player.field_70138_W = player.field_70131_O / 3.0f;
        player.field_70747_aH *= player.field_70131_O / 1.8f;
    }

    @SubscribeEvent
    public void onBreak(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        event.setNewSpeed(event.getOriginalSpeed() * (player.field_70131_O / 10.0f));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        float scale;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float thirdPersonDistancePrev = scale = player.field_70131_O / 1.8f;
        Entity entity = event.getEntity();
        double partialTicks = event.getRenderPartialTicks();
        float eyeHeight = entity.func_70047_e();
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * partialTicks + (double)eyeHeight;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * partialTicks;
        double d3 = (double)thirdPersonDistancePrev + (double)(scale - thirdPersonDistancePrev) * event.getRenderPartialTicks();
        if (Minecraft.func_71410_x().field_71474_y.field_74325_U) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-d3)));
        } else {
            float yaw = event.getEntity().field_70177_z;
            float pitch = event.getEntity().field_70125_A;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2) {
                pitch += 180.0f;
            }
            double d4 = (double)(-MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)))) * d3;
            double d5 = (double)(MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)))) * d3;
            double d6 = (double)(-MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)))) * d3;
            for (int i = 0; i < 8; ++i) {
                double d7;
                RayTraceResult raytraceresult;
                float f3 = (i & 1) * 2 - 1;
                float f4 = (i >> 1 & 1) * 2 - 1;
                float f5 = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = Minecraft.func_71410_x().field_71441_e.func_72933_a(new Vec3d(d0 + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f)), new Vec3d(d0 - d4 + (double)f3 + (double)f5, d1 - d6 + (double)f4, d2 - d5 + (double)f5))) == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < d3)) continue;
                d3 = d7;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && player.field_70131_O > 1.8f) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-d3) + scale));
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 && player.field_70131_O > 1.8f) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)d3 - scale));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onEntityRenderPre(RenderLivingEvent.Pre event) {
        float scale;
        ISizeCap cap;
        EntityLivingBase entity = event.getEntity();
        if (entity.hasCapability(SizeCapPro.sizeCapability, null) && (cap = (ISizeCap)entity.getCapability(SizeCapPro.sizeCapability, null)).getTrans() && (scale = entity.field_70131_O / cap.getDefaultHeight()) < 0.4f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)(scale * 2.5f), (float)1.0f, (float)(scale * 2.5f));
            GlStateManager.func_179137_b((double)(event.getX() / (double)scale * 2.5 - event.getX()), (double)(event.getY() / (double)scale * 2.5 - event.getY()), (double)(event.getZ() / (double)scale * 2.5 - event.getZ()));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onLivingRenderPost(RenderLivingEvent.Post event) {
        EntityLivingBase entity = event.getEntity();
        if (entity.hasCapability(SizeCapPro.sizeCapability, null)) {
            float scale;
            ISizeCap cap = (ISizeCap)entity.getCapability(SizeCapPro.sizeCapability, null);
            assert (cap != null);
            if (cap.getTrans() && (scale = entity.field_70131_O / cap.getDefaultHeight()) < 0.4f) {
                GlStateManager.func_179121_F();
            }
        }
    }
}

