/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.events;

import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.utils.XPConfigManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="minepiece")
public class PlayerXPEvents {
    private static final int SECONDS_BETWEEN_PASSIVE_XP = 60;
    private static final int PASSIVE_XP = 6;

    @SubscribeEvent
    public static void playerTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (PlayerXPEvents.isClientSide(event.getEntityLiving()) || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entity;
        int secondsLived = Math.floorDiv(playerMP.field_70173_aa, 20);
        if (secondsLived % XPConfigManager.getSecondsBetweenPassiveXP() == 0 && secondsLived > 0 && playerMP.field_70173_aa % 20 == 0) {
            PlayerUtils.addXpToPlayer(playerMP, XPConfigManager.getPassiveXPAmount());
            if (XPConfigManager.isGiveJobXP()) {
                PlayerUtils.addJobXpToPlayer(playerMP, XPConfigManager.getPassiveXPAmount());
            }
        }
    }

    private static boolean isClientSide(EntityLivingBase entityLivingBase) {
        return !(entityLivingBase instanceof EntityPlayer) || entityLivingBase.field_70170_p.field_72995_K;
    }
}

