/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.events;

import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import fr.minepiece.common.api.races.IMinePieceRace;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.api.stats.MinePieceAttributeModifier;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownProvider;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataProvider;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsProvider;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsProvider;
import fr.minepiece.common.init.ModConfiguration;
import fr.minepiece.common.init.ModPotions;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.OpenNameSelectionPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="minepiece")
public class PlayerEvents {
    public static final ResourceLocation MPDATA_LOCATION = new ResourceLocation("minepiece", "mpdata");
    public static final ResourceLocation MPSTATS_LOCATION = new ResourceLocation("minepiece", "mpstats");
    public static final ResourceLocation MPCOOLDOWN_LOCATION = new ResourceLocation("minepiece", "mpcooldown");
    public static final ResourceLocation PLAYER_MODIFICATIONS_LOCATION = new ResourceLocation("minepiece", "playermodifications");

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (data != null && data.getRace() == MinePieceRaces.GIANT) {
            IAttributeInstance heightAttribute = player.func_110148_a(ArtemisLibAttributes.ENTITY_HEIGHT);
            IAttributeInstance widthAttribute = player.func_110148_a(ArtemisLibAttributes.ENTITY_WIDTH);
            if (heightAttribute.func_111127_a(MinePieceAttributeModifier.GIANT_HEIGHT.getUuid()) == null && widthAttribute.func_111127_a(MinePieceAttributeModifier.GIANT_WIDTH.getUuid()) != null) {
                data.getRace().getInstance().init(player, player.field_70170_p);
            }
        } else if (data != null && data.getRace() == MinePieceRaces.TONTATTA) {
            IAttributeInstance heightAttribute = player.func_110148_a(ArtemisLibAttributes.ENTITY_HEIGHT);
            IAttributeInstance widthAttribute = player.func_110148_a(ArtemisLibAttributes.ENTITY_WIDTH);
            if (heightAttribute.func_111127_a(MinePieceAttributeModifier.TONTATTA_HEIGHT.getUuid()) == null && widthAttribute.func_111127_a(MinePieceAttributeModifier.TONTATTA_WIDTH.getUuid()) != null) {
                data.getRace().getInstance().init(player, player.field_70170_p);
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            e.addCapability(MPDATA_LOCATION, (ICapabilityProvider)new MinePieceDataProvider());
            e.addCapability(MPSTATS_LOCATION, (ICapabilityProvider)new MinePieceStatsProvider());
            e.addCapability(MPCOOLDOWN_LOCATION, (ICapabilityProvider)new MinePieceCooldownProvider());
            e.addCapability(PLAYER_MODIFICATIONS_LOCATION, (ICapabilityProvider)new PlayerModificationsProvider());
        }
    }

    @SubscribeEvent
    public static void playerUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(e.getEntityLiving() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)e.getEntityLiving();
        PlayerEvents.handlePlayerUpdate(player);
    }

    private static void handlePlayerUpdate(EntityPlayerMP player) {
        int raceID;
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (data == null) {
            return;
        }
        if ((data.getRPName() == null || data.getRPName().isEmpty()) && PlayerUtils.isPlayerOnline(player) && player.field_71135_a.field_147371_a.func_150724_d()) {
            ModPackets.NETWORK.sendTo((IMessage)new OpenNameSelectionPacket(), player);
        }
        if ((data.getRPLastName() == null || data.getRPLastName().isEmpty()) && PlayerUtils.isPlayerOnline(player) && player.field_71135_a.field_147371_a.func_150724_d()) {
            ModPackets.NETWORK.sendTo((IMessage)new OpenNameSelectionPacket(), player);
        }
        if ((raceID = data.getRaceID()) == -1) {
            return;
        }
        IMinePieceRace race = data.getRace().getInstance();
        if (data.getLevel() >= 20) {
            player.func_184102_h().func_152344_a(() -> race.powerUp((EntityPlayer)player, player.field_70170_p));
        } else {
            player.func_184102_h().func_152344_a(() -> race.passive((EntityPlayer)player, player.field_70170_p));
        }
        PlayerEvents.handleEnergyRegen(player);
    }

    private static void handleEnergyRegen(EntityPlayerMP player) {
        IMinePieceCooldown cooldown = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
        if (cooldown == null) {
            return;
        }
        if (cooldown.getEnergyRegen() < System.currentTimeMillis()) {
            player.func_184102_h().func_152344_a(() -> {
                IMinePieceStats stats = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
                if (stats != null) {
                    int additionnal = 0;
                    if (player.func_70644_a(ModPotions.ENERGY_REGEN_EFFECT)) {
                        additionnal = player.func_70660_b(ModPotions.ENERGY_REGEN_EFFECT).func_76458_c() + 1;
                    }
                    stats.addEnergy(1 + additionnal);
                    stats.clientSync(player);
                }
            });
            if (player.func_70644_a(ModPotions.ENERGY_REGEN_EFFECT)) {
                PotionEffect effect = player.func_70660_b(ModPotions.ENERGY_REGEN_EFFECT);
                cooldown.setEnergyRegen(System.currentTimeMillis() + (long)ModConfiguration.energy_regen_delay - (long)((effect.func_76458_c() + 1) * 1000));
            } else {
                cooldown.setEnergyRegen(System.currentTimeMillis() + (long)ModConfiguration.energy_regen_delay);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70644_a(ModPotions.COLA_EFFECT)) {
            PotionEffect colaEffect = entity.func_70660_b(ModPotions.COLA_EFFECT);
            int amplifier = colaEffect.func_76458_c() + 1;
            double reductionPercentage = (double)amplifier * 0.1;
            event.setAmount((float)((double)event.getAmount() * (1.0 - reductionPercentage)));
        }
    }
}

