/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityExplosiveProjectile
extends EntityThrowable {
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityExplosiveProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TIER = EntityDataManager.func_187226_a(EntityExplosiveProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> EXPLOSION_POWER = EntityDataManager.func_187226_a(EntityExplosiveProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> IS_PARABOLIC = EntityDataManager.func_187226_a(EntityExplosiveProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityExplosiveProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    private String weaponType;
    private boolean hasParabolicPath;
    private float gravity;
    private Entity ignoreEntity;
    private int maxTicksAlive = 100;
    private boolean breakBlocks = false;

    public EntityExplosiveProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityExplosiveProjectile(World worldIn, EntityLivingBase throwerIn, float damage, int tier, float explosionPower, boolean isParabolic, float gravity) {
        super(worldIn, throwerIn);
        this.func_70105_a(0.5f, 0.5f);
        this.ignoreEntity = throwerIn;
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        this.field_70180_af.func_187227_b(TIER, (Object)tier);
        this.field_70180_af.func_187227_b(EXPLOSION_POWER, (Object)Float.valueOf(explosionPower));
        this.field_70180_af.func_187227_b(IS_PARABOLIC, (Object)isParabolic);
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        this.hasParabolicPath = isParabolic;
        this.gravity = gravity;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(TIER, (Object)0);
        this.field_70180_af.func_187214_a(EXPLOSION_POWER, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(IS_PARABOLIC, (Object)true);
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(0.03f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70169_q != this.field_70165_t || this.field_70166_s != this.field_70161_v) {
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        }
        if (this.field_70167_r != this.field_70163_u) {
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        if (((Boolean)this.field_70180_af.func_187225_a(IS_PARABOLIC)).booleanValue()) {
            this.field_70181_x -= (double)((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
        }
        if (this.field_70170_p.field_72995_K) {
            int tier = (Integer)this.field_70180_af.func_187225_a(TIER);
            int particleCount = 2 + tier;
            for (int i = 0; i < particleCount; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t - this.field_70159_w * 0.25 + (this.field_70146_Z.nextDouble() - 0.5) * 0.4, this.field_70163_u - this.field_70181_x * 0.25 + (this.field_70146_Z.nextDouble() - 0.5) * 0.4, this.field_70161_v - this.field_70179_y * 0.25 + (this.field_70146_Z.nextDouble() - 0.5) * 0.4, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_70173_aa > this.maxTicksAlive) {
            this.explode();
        }
    }

    private void generateParticles() {
        if (this.field_70170_p.field_72995_K) {
            int tier = (Integer)this.field_70180_af.func_187225_a(TIER);
            for (int i = 0; i < 2 + tier; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 0.3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!(this.field_70170_p.field_72995_K || result.field_72308_g != null && result.field_72308_g == this.ignoreEntity)) {
            this.explode();
        }
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            float explosionPower = ((Float)this.field_70180_af.func_187225_a(EXPLOSION_POWER)).floatValue();
            boolean setFire = true;
            this.field_70170_p.func_72876_a((Entity)(this.func_85052_h() != null ? this.func_85052_h() : this), this.field_70165_t, this.field_70163_u, this.field_70161_v, explosionPower, this.breakBlocks);
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Damage", ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue());
        compound.func_74768_a("Tier", ((Integer)this.field_70180_af.func_187225_a(TIER)).intValue());
        compound.func_74776_a("ExplosionPower", ((Float)this.field_70180_af.func_187225_a(EXPLOSION_POWER)).floatValue());
        compound.func_74757_a("IsParabolic", ((Boolean)this.field_70180_af.func_187225_a(IS_PARABOLIC)).booleanValue());
        compound.func_74776_a("Gravity", ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue());
        compound.func_74778_a("WeaponType", this.weaponType != null ? this.weaponType : "");
        compound.func_74768_a("MaxTicksAlive", this.maxTicksAlive);
        compound.func_74757_a("BreakBlocks", this.breakBlocks);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(compound.func_74760_g("Damage")));
        this.field_70180_af.func_187227_b(TIER, (Object)compound.func_74762_e("Tier"));
        this.field_70180_af.func_187227_b(EXPLOSION_POWER, (Object)Float.valueOf(compound.func_74760_g("ExplosionPower")));
        this.field_70180_af.func_187227_b(IS_PARABOLIC, (Object)compound.func_74767_n("IsParabolic"));
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(compound.func_74760_g("Gravity")));
        this.weaponType = compound.func_74779_i("WeaponType");
        if (compound.func_74764_b("MaxTicksAlive")) {
            this.maxTicksAlive = compound.func_74762_e("MaxTicksAlive");
        }
        if (compound.func_74764_b("BreakBlocks")) {
            this.breakBlocks = compound.func_74767_n("BreakBlocks");
        }
        this.hasParabolicPath = (Boolean)this.field_70180_af.func_187225_a(IS_PARABOLIC);
        this.gravity = ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void setWeaponType(String weaponType) {
        this.weaponType = weaponType;
    }

    public String getWeaponType() {
        return this.weaponType;
    }

    public void setMaxTicksAlive(int ticks) {
        this.maxTicksAlive = ticks;
    }

    public void setIgnoreEntity(Entity entity) {
        this.ignoreEntity = entity;
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setTier(int tier) {
        this.field_70180_af.func_187227_b(TIER, (Object)tier);
    }

    public int getTier() {
        return (Integer)this.field_70180_af.func_187225_a(TIER);
    }

    public void setExplosionPower(float power) {
        this.field_70180_af.func_187227_b(EXPLOSION_POWER, (Object)Float.valueOf(power));
    }

    public float getExplosionPower() {
        return ((Float)this.field_70180_af.func_187225_a(EXPLOSION_POWER)).floatValue();
    }

    public void setParabolic(boolean isParabolic) {
        this.field_70180_af.func_187227_b(IS_PARABOLIC, (Object)isParabolic);
        this.hasParabolicPath = isParabolic;
    }

    public void setGravity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        this.gravity = gravity;
    }

    public void setBreakBlocks(boolean breakBlocks) {
        this.breakBlocks = breakBlocks;
    }
}

