/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityBullet
extends EntityThrowable {
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TIER = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_PARABOLIC = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> CAUSES_FIRE = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187198_h);
    private String weaponType;
    private boolean hasParabolicPath;
    private float gravity;
    private Entity ignoreEntity;
    private int maxTicksAlive = 200;
    private double distanceTraveled = 0.0;
    private double prevX;
    private double prevY;
    private double prevZ;

    public EntityBullet(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityBullet(World worldIn, EntityLivingBase throwerIn, float damage, int tier, boolean causesFire, boolean isParabolic, float gravity) {
        super(worldIn, throwerIn);
        this.func_70105_a(0.25f, 0.25f);
        this.ignoreEntity = throwerIn;
        this.prevX = this.field_70165_t;
        this.prevY = this.field_70163_u;
        this.prevZ = this.field_70161_v;
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        this.field_70180_af.func_187227_b(TIER, (Object)tier);
        this.field_70180_af.func_187227_b(CAUSES_FIRE, (Object)causesFire);
        this.field_70180_af.func_187227_b(IS_PARABOLIC, (Object)isParabolic);
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        this.hasParabolicPath = isParabolic;
        this.gravity = gravity;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(TIER, (Object)0);
        this.field_70180_af.func_187214_a(CAUSES_FIRE, (Object)false);
        this.field_70180_af.func_187214_a(IS_PARABOLIC, (Object)false);
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double dx = this.field_70165_t - this.prevX;
        double dy = this.field_70163_u - this.prevY;
        double dz = this.field_70161_v - this.prevZ;
        double distanceSegment = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.distanceTraveled += distanceSegment;
        this.prevX = this.field_70165_t;
        this.prevY = this.field_70163_u;
        this.prevZ = this.field_70161_v;
        if (this.field_70169_q != this.field_70165_t || this.field_70166_s != this.field_70161_v) {
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        }
        if (this.field_70167_r != this.field_70163_u) {
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        if (((Boolean)this.field_70180_af.func_187225_a(IS_PARABOLIC)).booleanValue()) {
            this.field_70181_x -= (double)((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
        }
        this.generateParticles();
        if (this.field_70173_aa > this.maxTicksAlive) {
            this.func_70106_y();
        }
    }

    private void generateParticles() {
        if (this.field_70170_p.field_72995_K) {
            int tier = (Integer)this.field_70180_af.func_187225_a(TIER);
            boolean causesFire = (Boolean)this.field_70180_af.func_187225_a(CAUSES_FIRE);
            EnumParticleTypes particleType = causesFire ? EnumParticleTypes.FLAME : EnumParticleTypes.SMOKE_NORMAL;
            for (int i = 0; i < 1 + tier; ++i) {
                this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 0.2, this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * 0.2, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 0.2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72308_g != null && result.field_72308_g != this.ignoreEntity) {
                float damage = ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
                boolean causesFire = (Boolean)this.field_70180_af.func_187225_a(CAUSES_FIRE);
                int tier = (Integer)this.field_70180_af.func_187225_a(TIER);
                DamageSource source = DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h());
                result.field_72308_g.func_70097_a(source, damage);
                if (causesFire && result.field_72308_g instanceof EntityLivingBase) {
                    int fireDuration = 2 + tier * 2;
                    result.field_72308_g.func_70015_d(fireDuration);
                }
            }
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Damage", ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue());
        compound.func_74768_a("Tier", ((Integer)this.field_70180_af.func_187225_a(TIER)).intValue());
        compound.func_74757_a("CausesFire", ((Boolean)this.field_70180_af.func_187225_a(CAUSES_FIRE)).booleanValue());
        compound.func_74757_a("IsParabolic", ((Boolean)this.field_70180_af.func_187225_a(IS_PARABOLIC)).booleanValue());
        compound.func_74776_a("Gravity", ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue());
        compound.func_74778_a("WeaponType", this.weaponType != null ? this.weaponType : "");
        compound.func_74768_a("MaxTicksAlive", this.maxTicksAlive);
        compound.func_74780_a("DistanceTraveled", this.distanceTraveled);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(compound.func_74760_g("Damage")));
        this.field_70180_af.func_187227_b(TIER, (Object)compound.func_74762_e("Tier"));
        this.field_70180_af.func_187227_b(CAUSES_FIRE, (Object)compound.func_74767_n("CausesFire"));
        this.field_70180_af.func_187227_b(IS_PARABOLIC, (Object)compound.func_74767_n("IsParabolic"));
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(compound.func_74760_g("Gravity")));
        this.weaponType = compound.func_74779_i("WeaponType");
        if (compound.func_74764_b("MaxTicksAlive")) {
            this.maxTicksAlive = compound.func_74762_e("MaxTicksAlive");
        }
        if (compound.func_74764_b("DistanceTraveled")) {
            this.distanceTraveled = compound.func_74769_h("DistanceTraveled");
        }
        this.hasParabolicPath = (Boolean)this.field_70180_af.func_187225_a(IS_PARABOLIC);
        this.gravity = ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void setWeaponType(String weaponType) {
        this.weaponType = weaponType;
    }

    public String getWeaponType() {
        return this.weaponType;
    }

    public void setMaxTicksAlive(int ticks) {
        this.maxTicksAlive = ticks;
    }

    public int getMaxTicksAlive() {
        return this.maxTicksAlive;
    }

    public void setIgnoreEntity(Entity entity) {
        this.ignoreEntity = entity;
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setTier(int tier) {
        this.field_70180_af.func_187227_b(TIER, (Object)tier);
    }

    public int getTier() {
        return (Integer)this.field_70180_af.func_187225_a(TIER);
    }

    public void setCausesFire(boolean causesFire) {
        this.field_70180_af.func_187227_b(CAUSES_FIRE, (Object)causesFire);
    }

    public boolean getCausesFire() {
        return (Boolean)this.field_70180_af.func_187225_a(CAUSES_FIRE);
    }

    public void setParabolic(boolean isParabolic) {
        this.field_70180_af.func_187227_b(IS_PARABOLIC, (Object)isParabolic);
        this.hasParabolicPath = isParabolic;
    }

    public void setGravity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        this.gravity = gravity;
    }

    public double getDistanceTraveled() {
        return this.distanceTraveled;
    }
}

