/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity;

import fr.minepiece.client.particles.ParticleSmoke;
import fr.minepiece.common.init.ModWeapons;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.PacketSpawnSmokeCloud;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySmokeBomb
extends EntityThrowable {
    private static final DataParameter<Integer> SMOKE_COLOR = EntityDataManager.func_187226_a(EntitySmokeBomb.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int DEFAULT_SMOKE_COLOR = 0xAA3939;
    private static final int SMOKE_DURATION = 760;
    private static final float SMOKE_RADIUS = 5.0f;
    private static final int PARTICLE_DENSITY = 250;
    private static final float TURBULENCE_FACTOR = 0.012f;
    private static final float VORTEX_STRENGTH = 0.006f;
    private static final float RISE_SPEED_VARIANCE = 0.004f;
    private static final ConcurrentHashMap<UUID, SmokeCloudData> activeSmokeEffects = new ConcurrentHashMap();

    public EntitySmokeBomb(World worldIn) {
        super(worldIn);
    }

    public EntitySmokeBomb(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public EntitySmokeBomb(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SMOKE_COLOR, (Object)0xAA3939);
    }

    public void setSmokeColor(int color) {
        this.field_70180_af.func_187227_b(SMOKE_COLOR, (Object)color);
    }

    public int getSmokeColor() {
        return (Integer)this.field_70180_af.func_187225_a(SMOKE_COLOR);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound smokeData = new NBTTagCompound();
            smokeData.func_74768_a("Color", this.getSmokeColor());
            smokeData.func_74768_a("Duration", 760);
            smokeData.func_74776_a("Radius", 5.0f);
            smokeData.func_74768_a("Density", 250);
            UUID smokeId = UUID.randomUUID();
            smokeData.func_186854_a("SmokeId", smokeId);
            this.registerSmokeCloud(smokeId, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, 760);
            this.spawnSmokeEffect(smokeData);
            PacketSpawnSmokeCloud packet = new PacketSpawnSmokeCloud(smokeId, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, this.getSmokeColor(), 0.7f, 760);
            ModPackets.NETWORK.sendToDimension((IMessage)packet, this.field_70170_p.field_73011_w.getDimension());
            this.func_70106_y();
        }
    }

    private void registerSmokeCloud(UUID id, double x, double y, double z, float radius, int duration) {
        SmokeCloudData cloudData = new SmokeCloudData(x, y, z, radius, this.field_70170_p.field_73011_w.getDimension(), this.field_70170_p.func_82737_E() + (long)duration);
        activeSmokeEffects.put(id, cloudData);
    }

    private void spawnSmokeEffect(NBTTagCompound smokeData) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        this.getEntityData().func_74782_a("SmokeData", (NBTBase)smokeData);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SmokeColor", this.getSmokeColor());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("SmokeColor")) {
            this.setSmokeColor(compound.func_74762_e("SmokeColor"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            NBTTagCompound smokeData = this.getEntityData().func_74775_l("SmokeData");
            int color = smokeData.func_74764_b("Color") ? smokeData.func_74762_e("Color") : 0xAA3939;
            int duration = smokeData.func_74764_b("Duration") ? smokeData.func_74762_e("Duration") : 760;
            float radius = smokeData.func_74764_b("Radius") ? smokeData.func_74760_g("Radius") : 5.0f;
            int density = smokeData.func_74764_b("Density") ? smokeData.func_74762_e("Density") : 250;
            this.createSmokeCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, color, radius, duration, density);
        } else {
            super.func_70103_a(id);
        }
    }

    public static void applyBlindingEffects() {
        if (activeSmokeEffects.isEmpty()) {
            return;
        }
        long currentTime = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].func_82737_E();
        activeSmokeEffects.forEach((id, data) -> {
            if (data.expirationTime < currentTime) {
                activeSmokeEffects.remove(id);
            }
        });
        if (activeSmokeEffects.isEmpty()) {
            return;
        }
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            boolean hasActiveCloudsInDimension = activeSmokeEffects.values().stream().anyMatch(arg_0 -> EntitySmokeBomb.lambda$applyBlindingEffects$1((World)world, arg_0));
            if (!hasActiveCloudsInDimension) continue;
            block1: for (EntityPlayer player : world.field_73010_i) {
                for (SmokeCloudData cloud : activeSmokeEffects.values()) {
                    int amplifier;
                    double dz;
                    double dy;
                    double dx;
                    double distanceSquared;
                    if (cloud.dimension != world.field_73011_w.getDimension() || !((distanceSquared = (dx = player.field_70165_t - cloud.x) * dx + (dy = player.field_70163_u - cloud.y) * dy + (dz = player.field_70161_v - cloud.z) * dz) <= (double)(cloud.radius * cloud.radius))) continue;
                    int duration = 40;
                    int n = amplifier = distanceSquared < (double)(cloud.radius * cloud.radius / 4.0f) ? 1 : 0;
                    if (!(player instanceof EntityPlayerMP)) continue block1;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, duration, amplifier, false, true));
                    continue block1;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void createSmokeCloud(World world, double x, double y, double z, int color, float radius, int duration, int density) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Random rand = new Random();
        this.spawnDenseCoreSmokeLayer(world, x, y, z, r, g, b, radius * 0.8f, density / 4, rand);
        this.spawnTurbulentSmokeLayer(world, x, y, z, r, g, b, radius, density / 4, rand);
        int numWaves = 10;
        for (int wave = 1; wave < 10; ++wave) {
            if (wave >= 8) {
                this.spawnAdvancedSmokeLayer(world, x, y + (double)wave * 0.05, z, r, g, b, radius * (0.4f + (float)wave * 0.06f), density / 3, rand, wave >= 9);
                continue;
            }
            this.spawnDenseCoreSmokeLayer(world, x, y + (double)wave * 0.05, z, r, g, b, radius * (0.4f + (float)wave * 0.06f), density / 3, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDenseCoreSmokeLayer(World world, double x, double y, double z, float r, float g, float b, float layerRadius, int particleCount, Random rand) {
        for (int layer = 0; layer < 3; ++layer) {
            double layerOffset = (double)layer * 0.2 - 0.2;
            for (int i = 0; i < particleCount / 3; ++i) {
                double phi = rand.nextDouble() * 2.0 * Math.PI;
                double theta = Math.acos(2.0 * rand.nextDouble() - 1.0);
                double rho = (double)layerRadius * Math.pow(rand.nextDouble(), 0.4);
                double offsetX = rho * Math.sin(theta) * Math.cos(phi);
                double offsetY = rho * Math.cos(theta) + layerOffset;
                double offsetZ = rho * Math.sin(theta) * Math.sin(phi);
                double speedX = offsetX * 2.0E-4;
                double speedY = 0.002 + rand.nextDouble() * 0.003;
                double speedZ = offsetZ * 2.0E-4;
                ParticleSmoke smokeParticle = new ParticleSmoke(world, x + offsetX, y + offsetY, z + offsetZ, speedX, speedY, speedZ);
                smokeParticle.func_70538_b(Math.min(1.0f, r * 1.2f), g, b);
                float scale = 0.9f + rand.nextFloat() * 0.2f;
                smokeParticle.func_70541_f(scale);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smokeParticle);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnTurbulentSmokeLayer(World world, double x, double y, double z, float r, float g, float b, float layerRadius, int particleCount, Random rand) {
        for (int layer = 0; layer < 3; ++layer) {
            double layerOffset = (double)layer * 0.2 - 0.2;
            for (int i = 0; i < particleCount / 3; ++i) {
                double phi = rand.nextDouble() * 2.0 * Math.PI;
                double theta = Math.acos(2.0 * rand.nextDouble() - 1.0);
                double rho = (double)layerRadius * Math.pow(rand.nextDouble(), 0.4);
                double offsetX = rho * Math.sin(theta) * Math.cos(phi);
                double offsetY = rho * Math.cos(theta) + layerOffset;
                double offsetZ = rho * Math.sin(theta) * Math.sin(phi);
                double speedX = offsetX * 2.0E-4 + (rand.nextDouble() - 0.5) * (double)0.012f;
                double speedY = 0.002 + rand.nextDouble() * 0.003 + (rand.nextDouble() - 0.3) * (double)0.004f;
                double speedZ = offsetZ * 2.0E-4 + (rand.nextDouble() - 0.5) * (double)0.012f;
                ParticleSmoke smokeParticle = new ParticleSmoke(world, x + offsetX, y + offsetY, z + offsetZ, speedX, speedY, speedZ);
                smokeParticle.func_70538_b(Math.min(1.0f, r * 1.2f), g * (0.9f + rand.nextFloat() * 0.2f), b * (0.9f + rand.nextFloat() * 0.2f));
                float scale = 0.85f + rand.nextFloat() * 0.3f;
                smokeParticle.func_70541_f(scale);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smokeParticle);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnAdvancedSmokeLayer(World world, double x, double y, double z, float r, float g, float b, float layerRadius, int particleCount, Random rand, boolean isLastLayer) {
        double baseRotationAngle = rand.nextDouble() * Math.PI;
        for (int layer = 0; layer < 3; ++layer) {
            double layerOffset = (double)layer * 0.25 - 0.2;
            for (int i = 0; i < particleCount / 3; ++i) {
                double phi = rand.nextDouble() * 2.0 * Math.PI;
                double theta = Math.acos(2.0 * rand.nextDouble() - 1.0);
                double rho = (double)layerRadius * Math.pow(rand.nextDouble(), 0.45454545454545453);
                double offsetX = rho * Math.sin(theta) * Math.cos(phi);
                double offsetY = rho * Math.cos(theta) + layerOffset;
                double offsetZ = rho * Math.sin(theta) * Math.sin(phi);
                double distFromCenter = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
                double angle = Math.atan2(offsetZ, offsetX) + baseRotationAngle;
                double vortexFactor = isLastLayer ? 0.009000000078231096 : (double)0.006f;
                double speedX = offsetX * 2.0E-4 + (rand.nextDouble() - 0.5) * (double)0.012f * 1.5 - Math.sin(angle) * distFromCenter * vortexFactor;
                double speedY = 0.002 + rand.nextDouble() * 0.004 + (rand.nextDouble() - 0.3) * (double)0.004f * 2.0;
                double speedZ = offsetZ * 2.0E-4 + (rand.nextDouble() - 0.5) * (double)0.012f * 1.5 + Math.cos(angle) * distFromCenter * vortexFactor;
                if (isLastLayer && distFromCenter > (double)layerRadius * 0.6) {
                    double waveEffect = Math.sin(angle * 3.0) * 0.005;
                    speedX += waveEffect;
                    speedZ += waveEffect;
                    if (rand.nextDouble() > 0.5) {
                        speedY += rand.nextDouble() * 0.003;
                    }
                }
                ParticleSmoke smokeParticle = new ParticleSmoke(world, x + offsetX, y + offsetY, z + offsetZ, speedX, speedY, speedZ);
                float colorVariation = 0.9f + rand.nextFloat() * 0.2f;
                smokeParticle.func_70538_b(Math.min(1.0f, r * 1.2f * colorVariation), g * colorVariation, b * colorVariation);
                float scale = 0.8f + rand.nextFloat() * 0.4f;
                if (offsetY > 0.0 && distFromCenter > (double)layerRadius * 0.6) {
                    scale *= 1.15f;
                }
                smokeParticle.func_70541_f(scale);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smokeParticle);
            }
        }
    }

    protected ItemStack getArrowStack() {
        return new ItemStack(ModWeapons.SMOKE_BOMB);
    }

    private static /* synthetic */ boolean lambda$applyBlindingEffects$1(World world, SmokeCloudData data) {
        return data.dimension == world.field_73011_w.getDimension();
    }

    private static class SmokeCloudData {
        final double x;
        final double y;
        final double z;
        final float radius;
        final int dimension;
        final long expirationTime;

        SmokeCloudData(double x, double y, double z, float radius, int dimension, long expirationTime) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.radius = radius;
            this.dimension = dimension;
            this.expirationTime = expirationTime;
        }
    }
}

