/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity;

import fr.minepiece.common.entity.CustomFireBall;
import fr.minepiece.common.entity.EntityWaterDrop;
import fr.minepiece.common.init.ModConfiguration;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityNewWaterShark
extends CustomFireBall
implements IAnimatable {
    protected static final AnimationBuilder FLY_ANIM = new AnimationBuilder().addAnimation("Attaque", Boolean.valueOf(true));
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private double originalYaw;
    private double originalPitch;
    protected float damage = ModConfiguration.fishman_watershark_damage;

    public EntityNewWaterShark(World worldIn) {
        super(worldIn);
        this.func_70105_a(4.0f, 2.0f);
    }

    public EntityNewWaterShark(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ, double outGoingYaw) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, (float)((double)shooter.field_70177_z - outGoingYaw), shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.originalPitch = shooter.field_70125_A;
        this.originalYaw = (double)shooter.field_70177_z - outGoingYaw;
        this.func_70105_a(3.25f, 2.0f);
    }

    public EntityNewWaterShark(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
        this.func_70105_a(4.0f, 2.0f);
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70173_aa == 1) {
            this.originalPitch = this.field_70125_A;
            this.originalYaw = this.field_70177_z;
        }
        if (this.field_70173_aa > 60) {
            this.func_70106_y();
        }
        super.func_70071_h_();
        this.field_70177_z = (float)this.originalYaw;
        this.field_70125_A = (float)this.originalPitch;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72308_g != null) {
                if (result.field_72308_g instanceof EntityWaterDrop) {
                    return;
                }
                if (!(this.shootingEntity instanceof EntityPlayer)) {
                    throw new IllegalStateException("Water sharks must be shot by players !");
                }
                boolean successfulHit = result.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.shootingEntity)), this.damage);
                if (successfulHit) {
                    this.func_174815_a(this.shootingEntity, result.field_72308_g);
                    this.func_70106_y();
                }
            } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.func_70106_y();
            }
        }
    }

    @Override
    protected boolean isFireballFiery() {
        return false;
    }

    @Override
    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.WATER_DROP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected CustomFireBall.ParticleFunction getParticleFunction() {
        return CustomFireBall.ParticleFunction.MIDDLE;
    }

    @Override
    protected float getMotionFactor() {
        return 0.85f;
    }

    private <E extends IAnimatable> PlayState flyAnimController(AnimationEvent<E> event) {
        event.getController().setAnimation(FLY_ANIM);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::flyAnimController));
    }
}

