/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity;

import fr.minepiece.common.entity.CustomFireBall;
import fr.minepiece.common.entity.EntityWaterDrop;
import fr.minepiece.common.init.ModConfiguration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityNewWaterDrop
extends CustomFireBall
implements IAnimatable {
    private int ticksInAir;
    private double originalYaw;
    private double originalPitch;
    protected static final AnimationBuilder FLY_ANIM = new AnimationBuilder().addAnimation("animation.model.action", Boolean.valueOf(true));
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected float damage = ModConfiguration.fishman_waterdrop_damage;

    public static Vec3d getMotionVector(double baseYaw, double basePitch, double outGoingYaw, double outGoingPitch, Vec3d looking, Vec3d startPos) {
        float speedFactor = 3.0f;
        double f1 = Math.cos(baseYaw * 0.01745329238474369);
        double f2 = Math.sin(baseYaw * 0.01745329238474369);
        double d1 = (looking.field_72450_a - startPos.field_72450_a + outGoingYaw * f1) * (double)speedFactor;
        double d3 = (looking.field_72449_c - startPos.field_72449_c + outGoingYaw * f2) * (double)speedFactor;
        double motionX = d1 + 0.5;
        double motionY = -outGoingPitch;
        double motionZ = d3 + 0.5;
        return new Vec3d(motionX, motionY, motionZ);
    }

    public EntityNewWaterDrop(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ, double outGoingYaw) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, (float)((double)shooter.field_70177_z - outGoingYaw), shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.originalPitch = shooter.field_70125_A;
        this.originalYaw = (double)shooter.field_70177_z - outGoingYaw;
    }

    public EntityNewWaterDrop(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
    }

    public EntityNewWaterDrop(World worldIn) {
        super(worldIn);
    }

    @Override
    protected boolean isFireballFiery() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70173_aa == 1) {
            this.originalPitch = this.field_70125_A;
            this.originalYaw = this.field_70177_z;
        }
        if (this.field_70173_aa > 100) {
            this.func_70106_y();
        }
        super.func_70071_h_();
        this.field_70177_z = (float)this.originalYaw;
        this.field_70125_A = (float)this.originalPitch;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72308_g != null) {
                if (result.field_72308_g instanceof EntityWaterDrop) {
                    return;
                }
                if (!result.field_72308_g.func_70045_F()) {
                    if (!(this.shootingEntity instanceof EntityPlayer)) {
                        throw new IllegalStateException("Water drops must be shot by players !");
                    }
                    boolean flag = result.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.shootingEntity)), this.damage);
                    if (flag) {
                        this.func_174815_a(this.shootingEntity, result.field_72308_g);
                    }
                }
            }
            this.func_70106_y();
        }
    }

    @Override
    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.WATER_DROP;
    }

    @Override
    protected float getMotionFactor() {
        return 0.85f;
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    protected CustomFireBall.ParticleFunction getParticleFunction() {
        return CustomFireBall.ParticleFunction.MIDDLE;
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        super.func_174815_a(entityLivingBaseIn, entityIn);
        if (entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
        }
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "Flying", 5.0f, this::flyAnimController));
    }

    protected <E extends EntityNewWaterDrop> PlayState flyAnimController(AnimationEvent<E> event) {
        event.getController().setAnimation(FLY_ANIM);
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static float calculateYawFromMotion(double motionX, double motionZ) {
        return (float)Math.toDegrees(Math.atan2(-motionX, motionZ));
    }

    public static float calculateYawFromMotion(double motionX, double motionZ, Vec3d center) {
        return (float)Math.toDegrees(Math.atan2(-motionX + center.field_72450_a, motionZ + center.field_72449_c));
    }

    public static float calculateYawFromMotion(double motionX, double motionZ, Vec3d startPos, Vec3d playerLookVector) {
        double dirX = startPos.field_72450_a - (startPos.field_72450_a + motionX);
        double dirZ = startPos.field_72449_c - (startPos.field_72449_c + motionZ);
        double dotProduct = dirX * playerLookVector.field_72450_a + dirZ * playerLookVector.field_72449_c;
        double crossProduct = dirX * playerLookVector.field_72449_c - dirZ * playerLookVector.field_72450_a;
        return (float)Math.toDegrees(Math.atan2(crossProduct, dotProduct));
    }
}

