/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityDynamite
extends EntityThrowable {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDynamite.class, (DataSerializer)DataSerializers.field_187192_b);
    private int fuse = 60;
    private static final float[] explosionPower = new float[]{3.0f, 4.0f, 5.0f, 8.0f, 12.0f, 20.0f, 30.0f, 50.0f};

    public EntityDynamite(World worldIn) {
        super(worldIn);
    }

    public EntityDynamite(World worldIn, EntityLivingBase throwerIn, int variant) {
        super(worldIn, throwerIn);
        this.setVariant(variant);
    }

    public EntityDynamite(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.fuse > 0) {
            --this.fuse;
            if (this.fuse <= 0 && !this.field_70170_p.field_72995_K) {
                this.explode();
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.5f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.fuse = Math.min(this.fuse, 10);
            this.field_70159_w *= 0.1;
            this.field_70181_x *= 0.1;
            this.field_70179_y *= 0.1;
        }
    }

    private void explode() {
        double maxDist;
        double distSq;
        double explosionX = this.field_70165_t;
        double explosionY = this.field_70163_u + (double)(this.field_70131_O / 16.0f);
        double explosionZ = this.field_70161_v;
        Random rand = this.field_70170_p.field_73012_v;
        this.func_70106_y();
        float power = explosionPower[this.getVariant()];
        boolean causesFire = true;
        this.field_70170_p.func_72876_a((Entity)this.func_85052_h(), explosionX, explosionY, explosionZ, power, causesFire);
        if (this.field_70192_c != null && !this.field_70192_c.field_70128_L && (distSq = this.field_70192_c.func_70092_e(explosionX, explosionY, explosionZ)) < (maxDist = (double)power * 2.0) * maxDist) {
            double distance = Math.sqrt(distSq);
            Vec3d explosionOriginVec = new Vec3d(explosionX, explosionY, explosionZ);
            double exposure = this.field_70170_p.func_72842_a(explosionOriginVec, this.field_70192_c.func_174813_aQ());
            double impact = (1.0 - distance / maxDist) * exposure;
            float damage = (float)((impact * impact + impact) / 2.0 * 7.0 * (double)power + 1.0);
            DamageSource damageSource = DamageSource.func_188405_b((EntityLivingBase)this.field_70192_c);
            if (damage > 0.0f) {
                this.field_70192_c.func_70097_a(damageSource, damage);
                double motionMultiplier = impact;
                if (this.field_70192_c instanceof EntityPlayer) {
                    // empty if block
                }
                this.field_70192_c.func_70024_g((this.field_70192_c.field_70165_t - explosionX) * motionMultiplier / distance, (this.field_70192_c.field_70163_u + (double)this.field_70192_c.func_70047_e() - explosionY) * motionMultiplier / distance, (this.field_70192_c.field_70161_v - explosionZ) * motionMultiplier / distance);
            }
        }
        if (this.field_70170_p instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.field_70170_p;
            worldServer.func_175739_a(EnumParticleTypes.EXPLOSION_HUGE, explosionX, explosionY, explosionZ, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
            worldServer.func_175739_a(EnumParticleTypes.FLAME, explosionX, explosionY, explosionZ, 15 + rand.nextInt(10), 0.3, 0.3, 0.3, 0.05, new int[0]);
            worldServer.func_175739_a(EnumParticleTypes.LAVA, explosionX, explosionY, explosionZ, 5 + rand.nextInt(5), 0.2, 0.1, 0.2, 0.0, new int[0]);
            int debrisCount = 30 + rand.nextInt(20);
            IBlockState blockBelow = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)explosionX), MathHelper.func_76128_c((double)(explosionY - 0.1)), MathHelper.func_76128_c((double)explosionZ)));
            int blockStateId = Block.func_176210_f((IBlockState)(blockBelow.func_177230_c() == Blocks.field_150350_a ? Blocks.field_150346_d.func_176223_P() : blockBelow));
            for (int i = 0; i < debrisCount; ++i) {
                double motionX = rand.nextGaussian() * 0.15;
                double motionY = rand.nextDouble() * 0.4 + 0.2;
                double motionZ = rand.nextGaussian() * 0.15;
                double magnitude = Math.sqrt(motionX * motionX + motionY * motionY + motionZ * motionZ);
                double speedScale = 0.8 + rand.nextDouble() * 0.5;
                motionX = motionX / magnitude * speedScale;
                motionY = motionY / magnitude * speedScale;
                motionZ = motionZ / magnitude * speedScale;
                double offsetX = (rand.nextDouble() - 0.5) * 0.5;
                double offsetY = (rand.nextDouble() - 0.5) * 0.5;
                double offsetZ = (rand.nextDouble() - 0.5) * 0.5;
                worldServer.func_175739_a(EnumParticleTypes.BLOCK_CRACK, explosionX + offsetX, explosionY + offsetY, explosionZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0, new int[]{blockStateId});
                worldServer.func_175688_a(EnumParticleTypes.BLOCK_CRACK, explosionX + offsetX, explosionY + offsetY, explosionZ + offsetZ, motionX, motionY, motionZ, new int[]{blockStateId});
                if (rand.nextInt(4) != 0) continue;
                worldServer.func_175688_a(EnumParticleTypes.ITEM_CRACK, explosionX + offsetX, explosionY + offsetY, explosionZ + offsetZ, motionX * 0.5, motionY * 0.5, motionZ * 0.5, new int[]{Item.func_150891_b((Item)Items.field_151016_H)});
            }
            int smokeCount = 50 + rand.nextInt(30);
            for (int i = 0; i < smokeCount; ++i) {
                double spread = 1.5;
                double smokeX = explosionX + (rand.nextDouble() - rand.nextDouble()) * spread;
                double smokeY = explosionY + rand.nextDouble() * spread * 0.8;
                double smokeZ = explosionZ + (rand.nextDouble() - rand.nextDouble()) * spread;
                double driftX = (smokeX - explosionX) * 0.05 + (rand.nextDouble() - 0.5) * 0.1;
                double driftY = 0.1 + rand.nextDouble() * 0.15;
                double driftZ = (smokeZ - explosionZ) * 0.05 + (rand.nextDouble() - 0.5) * 0.1;
                EnumParticleTypes smokeType = EnumParticleTypes.SMOKE_LARGE;
                if (rand.nextInt(3) == 0) {
                    smokeType = EnumParticleTypes.SMOKE_NORMAL;
                } else if (rand.nextInt(5) == 0) {
                    smokeType = EnumParticleTypes.EXPLOSION_NORMAL;
                } else if (rand.nextInt(8) == 0) {
                    smokeType = EnumParticleTypes.CLOUD;
                }
                worldServer.func_175688_a(smokeType, smokeX, smokeY, smokeZ, driftX, driftY, driftZ, new int[0]);
            }
        }
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }
}

