/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity;

import com.google.common.collect.Lists;
import fr.minepiece.common.init.ModItems;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.PacketBarqueMotion;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBarque
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityBarque.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityBarque.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityBarque.class, (DataSerializer)DataSerializers.field_187193_c);
    private static Field riddenByEntitiesField;
    private static Field ridingEntityField;
    private static double[][] SEAT_POSITIONS;
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private double waterLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;

    public EntityBarque(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 0.6f);
    }

    public EntityBarque(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y - 0.3, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.updateAABB();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.func_70106_y();
                return true;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_145778_a(ModItems.BARQUE, 1, 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        int index;
        if (this.func_184196_w(passenger) && (index = this.func_184188_bt().indexOf(passenger)) >= 0 && index < SEAT_POSITIONS.length) {
            double[] pos = SEAT_POSITIONS[index];
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? 0.01 : this.func_70042_X()) + passenger.func_70033_W());
            Vec3d vec3d = new Vec3d(pos[0], pos[1] + (double)f1, pos[2]).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + vec3d.field_72448_b, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
        this.updateAABB();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            List passengers = this.func_184188_bt();
            if (passengers.contains(player)) {
                return true;
            }
            if (passengers.size() < SEAT_POSITIONS.length) {
                this.func_184200_o((Entity)player);
                return true;
            }
        }
        return true;
    }

    public void func_70071_h_() {
        this.previousStatus = this.status;
        this.status = this.getBarqueStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.tickLerp();
        if (this.func_184186_bw()) {
            EntityPlayer entityplayer = (EntityPlayer)this.func_184188_bt().get(0);
            this.updateMotion();
            if (this.field_70170_p.field_72995_K) {
                this.controlBarque();
                if (this.field_70170_p.func_82737_E() % 5L == 0L) {
                    ModPackets.NETWORK.sendToServer((IMessage)new PacketBarqueMotion(this.func_145782_y(), this.field_70159_w, this.field_70181_x, this.field_70179_y));
                }
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updatePosition();
        }
        if (this.field_70170_p.func_82737_E() % 30L == 0L) {
            this.updateAABB();
        }
    }

    private void updatePosition() {
        for (EntityPlayer player : ((WorldServer)this.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this)) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)this));
        }
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityPlayer;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        if (!list.isEmpty() && list.get(0) instanceof EntityLivingBase) {
            return (Entity)list.get(0);
        }
        if (list.size() > 1 && list.get(1) instanceof EntityLivingBase) {
            return (Entity)list.get(1);
        }
        return null;
    }

    public void func_184200_o(Entity passenger) {
        List<Entity> riders = this.getActualPassengers();
        if (riders.size() < SEAT_POSITIONS.length && !riders.contains(passenger)) {
            riders.add(passenger);
            this.setRidingEntity(passenger, this);
            this.func_184232_k(passenger);
        }
    }

    public void func_184225_p(Entity passenger) {
        List<Entity> riders = this.getActualPassengers();
        if (riders.contains(passenger)) {
            riders.remove(passenger);
            this.setRidingEntity(passenger, null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    private void updateInputs(float strafe, float forward) {
        this.leftInputDown = strafe < 0.0f;
        this.rightInputDown = strafe > 0.0f;
        this.forwardInputDown = forward > 0.0f;
        this.backInputDown = forward < 0.0f;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private void updateMotion() {
        double d1 = -0.04f;
        double d2 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d3 = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b + (double)this.field_70131_O;
            this.func_70107_b(this.field_70165_t, (double)(this.getWaterLevelAbove() - this.field_70131_O) + 0.101, this.field_70161_v);
            this.field_70181_x = 0.0;
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d3 = (this.waterLevel - this.func_174813_aQ().field_72338_b) / (double)this.field_70131_O;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER || this.status == Status.UNDER_WATER) {
                d2 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.momentum = 0.9f;
                if (this.func_184179_bs() instanceof EntityPlayer) {
                    this.boatGlide /= 2.0f;
                }
            }
            this.field_70159_w *= (double)this.momentum;
            this.field_70179_y *= (double)this.momentum;
            this.deltaRotation *= this.momentum;
            this.field_70181_x += d2;
            if (d3 > 0.0) {
                double d4 = 0.65;
                this.field_70181_x += d3 * 0.06153846016296973;
                double d5 = 0.75;
                this.field_70181_x *= 0.75;
            }
        }
    }

    private void controlBarque() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += -1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.forwardInputDown) {
                f += 0.08f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = k; k1 < l; ++k1) {
                float f = 0.0f;
                block5: for (int l1 = i; l1 < j; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(l1, k1, i2);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (state.func_185904_a() == Material.field_151586_h) {
                            f = Math.max(f, BlockLiquid.func_190973_f((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos));
                        }
                        if (f >= 1.0f) continue block5;
                    }
                }
                if (!(f < 1.0f)) continue;
                float f2 = (float)blockpos$pooledmutableblockpos.func_177956_o() + f;
                return f2;
            }
            float f = l + 1;
            return f;
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
    }

    public Status getBarqueStatus() {
        Status entitybarque$status = this.getUnderwaterStatus();
        if (entitybarque$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return entitybarque$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getBoatGlide() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        ArrayList list = Lists.newArrayList();
        float f = 0.0f;
        int k1 = 0;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                    if (j2 == 2) continue;
                    for (int k2 = k; k2 < l; ++k2) {
                        if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                        blockpos$pooledmutableblockpos.func_181079_c(l1, k2, i2);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        state.func_185908_a(this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, axisalignedbb1, (List)list, (Entity)this, false);
                        if (!list.isEmpty()) {
                            f += state.func_177230_c().field_149765_K;
                            ++k1;
                        }
                        list.clear();
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return f / (float)k1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (state.func_185904_a() != Material.field_151586_h || !(d0 < (double)BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos) + (double)blockpos$pooledmutableblockpos.func_177956_o())) continue;
                        if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                            Status entitybarque$status;
                            Status status = entitybarque$status = Status.UNDER_FLOWING_WATER;
                            return status;
                        }
                        flag = true;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag ? Status.UNDER_WATER : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (state.func_185904_a() != Material.field_151586_h) continue;
                        float f = BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.field_72338_b < (double)f;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    private List<Entity> getActualPassengers() {
        try {
            return (List)riddenByEntitiesField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private void setRidingEntity(Entity passenger, Entity riding) {
        try {
            ridingEntityField.set(passenger, riding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public double func_70042_X() {
        return 0.4;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("Damage", this.getDamageTaken());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("Damage")) {
            this.setDamageTaken(compound.func_74760_g("Damage"));
        }
    }

    private void updateAABB() {
        double halfLength = 2.5;
        double halfWidth = 1.0;
        double halfHeight = 0.3;
        float yawRad = this.field_70177_z * (float)Math.PI / 180.0f;
        double xExtent = Math.abs(halfLength * Math.sin(yawRad)) + Math.abs(halfWidth * Math.cos(yawRad));
        double zExtent = Math.abs(halfLength * Math.cos(yawRad)) + Math.abs(halfWidth * Math.sin(yawRad));
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - xExtent, this.field_70163_u, this.field_70161_v - zExtent, this.field_70165_t + xExtent, this.field_70163_u + 1.2, this.field_70161_v + zExtent));
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int forwardDirection) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    static {
        try {
            riddenByEntitiesField = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_184244_h");
            riddenByEntitiesField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ridingEntityField = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_184239_as");
            ridingEntityField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SEAT_POSITIONS = new double[][]{{-2.3, 0.0, 0.5}, {-2.3, 0.0, -0.5}, {0.5, 0.0, 0.5}, {0.5, 0.0, -0.5}};
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

