/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.entity;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class AbstractBoat
extends EntityBoat {
    private static Field riddenByEntitiesField;
    private static Field ridingEntityField;
    protected static double[][] SEAT_POSITIONS;

    public AbstractBoat(World worldIn) {
        super(worldIn);
        this.initSeatPositions();
    }

    public AbstractBoat(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.initSeatPositions();
    }

    protected abstract void initSeatPositions();

    public void func_184232_k(Entity passenger) {
        int index;
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger) && (index = this.func_184188_bt().indexOf(passenger)) >= 0 && index < SEAT_POSITIONS.length) {
            double[] pos = SEAT_POSITIONS[index];
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? 0.01 : this.func_70042_X()) + passenger.func_70033_W());
            Vec3d vec3d = new Vec3d(pos[0], pos[1] + (double)f1, pos[2]).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + vec3d.field_72448_b, this.field_70161_v + vec3d.field_72449_c);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.getActualPassengers().size() == 0) {
            return super.func_184230_a(player, hand);
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            List passengers = this.func_184188_bt();
            if (passengers.contains(player)) {
                return true;
            }
            if (passengers.size() < SEAT_POSITIONS.length) {
                this.func_184200_o((Entity)player);
                return true;
            }
        }
        return true;
    }

    public void func_184200_o(Entity passenger) {
        List<Entity> riders = this.getActualPassengers();
        if (riders.size() < SEAT_POSITIONS.length && !riders.contains(passenger)) {
            riders.add(passenger);
            this.setRidingEntity(passenger, (Entity)this);
            this.func_184232_k(passenger);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    private List<Entity> getActualPassengers() {
        try {
            return (List)riddenByEntitiesField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private void setRidingEntity(Entity passenger, Entity riding) {
        try {
            ridingEntityField.set(passenger, riding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return super.func_70114_g(entityIn);
    }

    public AxisAlignedBB func_70046_E() {
        return super.func_70046_E();
    }

    private void updateAABB() {
        double halfLength = 2.5;
        double halfWidth = 1.0;
        double halfHeight = 0.3;
        float yawRad = this.field_70177_z * (float)Math.PI / 180.0f;
        double xExtent = Math.abs(halfLength * Math.sin(yawRad)) + Math.abs(halfWidth * Math.cos(yawRad));
        double zExtent = Math.abs(halfLength * Math.cos(yawRad)) + Math.abs(halfWidth * Math.sin(yawRad));
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - xExtent, this.field_70163_u, this.field_70161_v - zExtent, this.field_70165_t + xExtent, this.field_70163_u + 1.2, this.field_70161_v + zExtent));
    }

    protected void func_184454_a(Entity entityToUpdate) {
        super.func_184454_a(entityToUpdate);
        this.updateAABB();
    }

    public double func_70042_X() {
        return 0.4;
    }

    public abstract float getSpeedMultiplier();

    static {
        try {
            riddenByEntitiesField = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_184244_h");
            riddenByEntitiesField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ridingEntityField = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_184239_as");
            ridingEntityField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

