/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.craft;

import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.craft.IMinePieceCraftingRecipe;
import fr.minepiece.common.craft.MinePieceDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public abstract class MinePieceCraftingTileEntity
extends TileEntity
implements IMinePieceCraftingInventory,
ITickable {
    protected NonNullList<ItemStack> inventory;
    protected EntityPlayer usingPlayer;
    protected int processTime;
    protected int craftResult;
    protected List<CraftingResult.ItemPosition> pendingConsumptions;
    protected boolean limitAlreadyReduced = false;

    public MinePieceCraftingTileEntity(int inventorySize) {
        this.inventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.pendingConsumptions = new ArrayList<CraftingResult.ItemPosition>();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.usingPlayer != null) {
            if (this.processTime > 0) {
                --this.processTime;
                if (this.processTime <= 0) {
                    this.limitAlreadyReduced = false;
                    this.processCraft();
                    IMinePieceCraftingRecipe recipe = this.getCurrentRecipe();
                    if (recipe != null && this.canCraft(recipe) && this.func_70301_a(this.getOutputSlot()).func_190926_b()) {
                        this.startCraftingProcess();
                    }
                }
                this.func_70296_d();
            } else {
                this.checkPendingCrafts();
            }
        }
    }

    protected void checkPendingCrafts() {
        if (this.craftResult > 0 && this.func_70301_a(this.getOutputSlot()).func_190926_b() && !this.pendingConsumptions.isEmpty()) {
            for (CraftingResult.ItemPosition pos : this.pendingConsumptions) {
                ItemStack stack = this.func_70301_a(pos.slot);
                if (stack.func_190926_b()) continue;
                stack.func_190918_g(pos.count);
                if (!stack.func_190926_b()) continue;
                this.func_70299_a(pos.slot, ItemStack.field_190927_a);
            }
            this.pendingConsumptions.clear();
            this.craftResult = 0;
        }
    }

    protected abstract void processCraft();

    protected abstract IMinePieceCraftingRecipe getCurrentRecipe();

    protected void handleSuccessfulCraft(IMinePieceCraftingRecipe recipe, CraftingResult result) {
        if (!(this.usingPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)this.usingPlayer;
        IMinePieceData mpData = MinePieceDataHelper.getPlayerData((EntityPlayer)player);
        if (mpData == null) {
            return;
        }
        float xpMultiplier = recipe.getXpMultiplier(this.getStationType());
        int totalXp = Math.round((float)(recipe.getBaseXpReward() * result.getCraftCount()) * xpMultiplier);
        MinePieceDataHelper.addJobXpToPlayer(player, totalXp);
        mpData.clientSync(player);
        if (!this.limitAlreadyReduced) {
            int newLimit = mpData.getDailyCraftLimit() - result.getCraftCount();
            mpData.setDailyCraftLimit(Math.max(0, newLimit));
            mpData.clientSync(player);
            this.limitAlreadyReduced = true;
        }
        StringBuilder message = new StringBuilder();
        message.append(TextFormatting.GREEN).append("Craft r\u00e9ussi ! ");
        message.append(TextFormatting.GOLD).append("+").append(totalXp).append(" XP");
        if (xpMultiplier > 1.0f) {
            message.append(TextFormatting.GREEN).append(" (").append(TextFormatting.GOLD).append("+").append(Math.round((xpMultiplier - 1.0f) * 100.0f)).append("% ").append(TextFormatting.GREEN).append("bonus)");
        }
        if (result.getCraftCount() > 1) {
            message.append(TextFormatting.AQUA).append(" x").append(result.getCraftCount());
        }
        player.func_145747_a((ITextComponent)new TextComponentString(message.toString()));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Craft journalier restant : " + TextFormatting.GOLD + mpData.getDailyCraftLimit()));
    }

    protected abstract int getStationType();

    @Override
    public EntityPlayer getUsingPlayer() {
        return this.usingPlayer;
    }

    public void setUsingPlayer(EntityPlayer player) {
        this.usingPlayer = player;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        compound.func_74768_a("ProcessTime", this.processTime);
        compound.func_74768_a("CraftResult", this.craftResult);
        compound.func_74757_a("LimitReduced", this.limitAlreadyReduced);
        if (!this.pendingConsumptions.isEmpty()) {
            NBTTagCompound pendingTag = new NBTTagCompound();
            pendingTag.func_74768_a("Count", this.pendingConsumptions.size());
            for (int i = 0; i < this.pendingConsumptions.size(); ++i) {
                CraftingResult.ItemPosition pos = this.pendingConsumptions.get(i);
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74768_a("Slot", pos.slot);
                itemTag.func_74768_a("Count", pos.count);
                pendingTag.func_74782_a("Item" + i, (NBTBase)itemTag);
            }
            compound.func_74782_a("PendingConsumptions", (NBTBase)pendingTag);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.processTime = compound.func_74762_e("ProcessTime");
        this.craftResult = compound.func_74762_e("CraftResult");
        this.limitAlreadyReduced = compound.func_74767_n("LimitReduced");
        this.pendingConsumptions.clear();
        if (compound.func_74764_b("PendingConsumptions")) {
            NBTTagCompound pendingTag = compound.func_74775_l("PendingConsumptions");
            int count = pendingTag.func_74762_e("Count");
            for (int i = 0; i < count; ++i) {
                NBTTagCompound itemTag = pendingTag.func_74775_l("Item" + i);
                int slot = itemTag.func_74762_e("Slot");
                int itemCount = itemTag.func_74762_e("Count");
                this.pendingConsumptions.add(new CraftingResult.ItemPosition(slot, itemCount));
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        return this.inventory.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        IMinePieceCraftingRecipe recipe;
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == this.getOutputSlot() && stack.func_190926_b() && this.craftResult > 0) {
            this.checkPendingCrafts();
        }
        if (index != this.getOutputSlot() && !this.field_145850_b.field_72995_K && (recipe = this.getCurrentRecipe()) != null && this.canCraft(recipe)) {
            this.startCraftingProcess();
        }
        this.func_70296_d();
    }

    protected abstract void startCraftingProcess();

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != this.getOutputSlot();
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.processTime;
            }
            case 1: {
                return this.craftResult;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.processTime = value;
                break;
            }
            case 1: {
                this.craftResult = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.inventory.clear();
        this.pendingConsumptions.clear();
        this.craftResult = 0;
    }
}

