/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.craft;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.craft.IMinePieceCraftingRecipe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public abstract class AbstractSimpleMinePieceRecipe
extends ShapedOreRecipe
implements IMinePieceCraftingRecipe {
    protected final ItemStack result;
    protected final int levelRequired;
    protected final int xpReward;
    protected final MinePieceJobs requiredJob;
    protected final Ingredient ingredient;

    public AbstractSimpleMinePieceRecipe(ResourceLocation group, ItemStack result, Ingredient ingredient, int levelRequired, int xpReward, MinePieceJobs requiredJob) {
        super(group, result, AbstractSimpleMinePieceRecipe.createPrimer(ingredient));
        this.result = result;
        this.ingredient = ingredient;
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.requiredJob = requiredJob;
    }

    private static CraftingHelper.ShapedPrimer createPrimer(Ingredient ingredient) {
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = 1;
        primer.height = 1;
        primer.mirrored = false;
        primer.input = NonNullList.func_191197_a((int)1, (Object)ingredient);
        return primer;
    }

    @Override
    public boolean matches(IMinePieceCraftingInventory inventory, World world) {
        ItemStack input = inventory.func_70301_a(0);
        return !input.func_190926_b() && this.ingredient.apply(input);
    }

    @Override
    public CraftingResult getCraftingResult(IMinePieceCraftingInventory inventory) {
        ItemStack input = inventory.func_70301_a(0);
        if (input.func_190926_b() || !this.ingredient.apply(input)) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        int multiplier = Math.min(input.func_190916_E(), this.result.func_77976_d() / this.result.func_190916_E());
        ItemStack craftedResult = this.result.func_77946_l();
        craftedResult.func_190920_e(craftedResult.func_190916_E() * multiplier);
        ArrayList<CraftingResult.ItemPosition> consumedItems = new ArrayList<CraftingResult.ItemPosition>();
        consumedItems.add(new CraftingResult.ItemPosition(0, multiplier));
        return new CraftingResult(craftedResult, multiplier, consumedItems);
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getBaseXpReward() {
        return this.xpReward;
    }

    @Override
    public MinePieceJobs getRequiredJob() {
        return this.requiredJob;
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }
}

